/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lunark.io.ServerEssentials;
import net.lunark.io.auction.AuctionItem;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class AuctionManager {
    private final ServerEssentials plugin;
    private final File storageFile;
    private FileConfiguration storageConfig;
    private final List<AuctionItem> auctionItems = new ArrayList<AuctionItem>();

    public AuctionManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.storageFile = new File(plugin.getDataFolder(), "storage/auctionitems.yml");
        if (!this.storageFile.exists()) {
            this.storageFile.getParentFile().mkdirs();
            try {
                this.storageFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        this.loadItems();
    }

    public void addAuctionItem(AuctionItem item) {
        this.auctionItems.add(item);
        this.saveItems();
    }

    public void removeAuctionItem(AuctionItem item) {
        this.auctionItems.remove(item);
        this.saveItems();
    }

    public List<AuctionItem> getAuctionItems() {
        return new ArrayList<AuctionItem>(this.auctionItems);
    }

    public List<AuctionItem> getPlayerItems(UUID player) {
        ArrayList<AuctionItem> list = new ArrayList<AuctionItem>();
        for (AuctionItem item : this.auctionItems) {
            if (!item.getSeller().equals(player)) continue;
            list.add(item);
        }
        return list;
    }

    public void saveItems() {
        this.storageConfig.set("items", null);
        int i = 0;
        for (AuctionItem item : this.auctionItems) {
            this.storageConfig.set("items." + i + ".seller", (Object)item.getSeller().toString());
            this.storageConfig.set("items." + i + ".item", (Object)item.getItem());
            this.storageConfig.set("items." + i + ".price", (Object)item.getPrice());
            this.storageConfig.set("items." + i + ".expiration", (Object)item.getExpiration());
            ++i;
        }
        try {
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadItems() {
        if (!this.storageConfig.contains("items")) {
            return;
        }
        this.auctionItems.clear();
        for (String key : this.storageConfig.getConfigurationSection("items").getKeys(false)) {
            UUID seller = UUID.fromString(this.storageConfig.getString("items." + key + ".seller"));
            double price = this.storageConfig.getDouble("items." + key + ".price");
            long expiration = this.storageConfig.getLong("items." + key + ".expiration");
            this.auctionItems.add(new AuctionItem(seller, this.storageConfig.getItemStack("items." + key + ".item"), price, expiration));
        }
    }
}

