/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Vault;

import net.lunark.io.Vault.VaultManager;
import net.lunark.io.util.VaultMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VaultCommand
implements CommandExecutor {
    private final VaultManager vaultManager;
    private final VaultMessages messages;

    public VaultCommand(VaultManager vaultManager, VaultMessages messages) {
        this.vaultManager = vaultManager;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Vault.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.messages.get("Vault.usage", new String[0]));
            return true;
        }
        try {
            int vaultNumber = Integer.parseInt(args[0]);
            if (vaultNumber < 1 || vaultNumber > 10) {
                player.sendMessage(this.messages.get("Vault.invalid-number", new String[0]));
                return true;
            }
            this.vaultManager.openVault(player, vaultNumber);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messages.get("Vault.invalid-number", new String[0]));
        }
        return true;
    }
}

