/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.TPA;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPA
implements CommandExecutor,
Listener {
    private static TPA instance;
    private final JavaPlugin plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final PlainTextComponentSerializer plain = PlainTextComponentSerializer.plainText();
    private Economy econ;
    private FileConfiguration config;
    private FileConfiguration messages;
    private File configFile;
    private File msgFile;
    private final Map<UUID, List<TpaRequest>> requests = new ConcurrentHashMap<UUID, List<TpaRequest>>();
    private final Set<UUID> tpaToggle = Collections.synchronizedSet(new HashSet());
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public TPA(JavaPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        this.loadConfigs();
        this.setupEconomy();
        this.registerCommands();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void registerCommands() {
        Objects.requireNonNull(this.plugin.getCommand("tpa")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpahere")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpaccept")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpdeny")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpacancel")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpall")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpatoggle")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tpainfo")).setExecutor((CommandExecutor)this);
    }

    public static TPA getInstance() {
        return instance;
    }

    public void reload() {
        this.loadConfigs();
        this.setupEconomy();
        Bukkit.getLogger().info("[TPA] Reloaded TPA configs and messages.");
    }

    public static void fullReload() {
        if (instance == null) {
            Bukkit.getLogger().warning("[TPA] Tried to reload before initialization!");
            return;
        }
        instance.reload();
    }

    private void loadConfigs() {
        this.configFile = new File(this.plugin.getDataFolder(), "config/tpa/tpa.yml");
        this.msgFile = new File(this.plugin.getDataFolder(), "messages/tpa.yml");
        this.configFile.getParentFile().mkdirs();
        this.msgFile.getParentFile().mkdirs();
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config/tpa/tpa.yml", false);
        }
        if (!this.msgFile.exists()) {
            this.plugin.saveResource("messages/tpa.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.msgFile);
        this.config.addDefault("settings.cooldown", (Object)5);
        this.config.addDefault("settings.timeout", (Object)60);
        this.config.addDefault("settings.warmup", (Object)0);
        this.config.addDefault("settings.teleport-delay", (Object)3);
        this.config.addDefault("settings.cancel-on-move", (Object)true);
        this.config.addDefault("settings.block-move-threshold-blocks", (Object)true);
        this.config.addDefault("notifications.chat", (Object)true);
        this.config.addDefault("notifications.actionbar", (Object)false);
        this.config.addDefault("notifications.bossbar", (Object)false);
        this.config.addDefault("notifications.bossbar-color", (Object)"BLUE");
        this.config.addDefault("notifications.bossbar-style", (Object)"SOLID");
        this.config.addDefault("notifications.bossbar-duration", (Object)5);
        this.config.addDefault("particles.enabled", (Object)true);
        this.config.addDefault("particles.type", (Object)"PORTAL");
        this.config.addDefault("economy.enabled", (Object)false);
        this.config.addDefault("economy.cost.tpa", (Object)0.0);
        this.config.addDefault("economy.cost.tpahere", (Object)0.0);
        this.config.addDefault("economy.cost.tpall", (Object)0.0);
        this.config.addDefault("economy.refund-on-deny", (Object)true);
        this.config.addDefault("economy.refund-on-expire", (Object)true);
        this.config.options().copyDefaults(true);
    }

    private void setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            this.econ = (Economy)rsp.getProvider();
        }
    }

    private void send(Player p, String path, Map<String, String> placeholders) {
        String raw = this.messages.getString(path, "<red>Missing message: " + path + "</red>");
        String prefix = this.messages.getString("prefix", "<gray>[TPA]</gray> ");
        raw = raw.replace("<prefix>", prefix);
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace("%" + e.getKey() + "%", e.getValue());
            }
        }
        Object msg = this.mm.deserialize(raw);
        if (this.config.getBoolean("notifications.chat", true)) {
            p.sendMessage(msg);
        }
        if (this.config.getBoolean("notifications.actionbar", false)) {
            p.sendActionBar(msg);
        }
        if (this.config.getBoolean("notifications.bossbar", false)) {
            BarStyle barStyle;
            BarColor barColor;
            String colorStr = this.config.getString("notifications.bossbar-color", "BLUE").toUpperCase();
            String styleStr = this.config.getString("notifications.bossbar-style", "SOLID").toUpperCase();
            int durationSec = Math.max(1, this.config.getInt("notifications.bossbar-duration", 5));
            try {
                barColor = BarColor.valueOf((String)colorStr);
            }
            catch (IllegalArgumentException ex) {
                barColor = BarColor.BLUE;
            }
            try {
                barStyle = BarStyle.valueOf((String)styleStr);
            }
            catch (IllegalArgumentException ex) {
                barStyle = BarStyle.SOLID;
            }
            final BossBar bar = Bukkit.createBossBar((String)this.plain.serialize(msg), (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
            bar.addPlayer(p);
            bar.setProgress(1.0);
            final long ticks = (long)durationSec * 20L;
            final long step = Math.max(1L, ticks / 20L);
            new BukkitRunnable(this){
                long remaining;
                {
                    this.remaining = ticks;
                }

                public void run() {
                    if (this.remaining <= 0L) {
                        bar.removeAll();
                        this.cancel();
                        return;
                    }
                    double progress = Math.max(0.0, (double)this.remaining / (double)ticks);
                    bar.setProgress(progress);
                    this.remaining -= step;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, step);
        }
        if (this.config.getBoolean("notifications.title", false)) {
            Object title = this.mm.deserialize(this.config.getString("notifications.title-color", "<gold>") + raw);
            Object subtitle = this.mm.deserialize(this.config.getString("notifications.subtitle-color", "<yellow>"));
            p.showTitle(Title.title(title, subtitle));
        }
        if (this.config.getBoolean("logging.enabled", false)) {
            String plainText = this.plain.serialize(msg);
            if (this.config.getBoolean("logging.to-console", true)) {
                Bukkit.getLogger().info("[TPA] Sent to " + p.getName() + ": " + plainText);
            }
            if (this.config.getBoolean("logging.to-file", false)) {
                File logFile = new File(this.plugin.getDataFolder(), "tpa.log");
                try {
                    Files.writeString(logFile.toPath(), (CharSequence)(p.getName() + ": " + plainText + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    Bukkit.getLogger().warning("Failed to write TPA log: " + e.getMessage());
                }
            }
        }
    }

    private int getInt(String path, int def) {
        return this.config.getInt("settings." + path, def);
    }

    private boolean getBool(String path, boolean def) {
        return this.config.getBoolean("settings." + path, def);
    }

    private void playSound(Player p, String key) {
        String soundStr = this.config.getString("sounds." + key, "ENTITY_EXPERIENCE_ORB_PICKUP");
        try {
            Sound s = Sound.valueOf((String)soundStr);
            p.playSound(p.getLocation(), s, 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean charge(Player p, String type, TpaRequest req) {
        if (!this.config.getBoolean("economy.enabled")) {
            return true;
        }
        if (this.econ == null) {
            return true;
        }
        double cost = this.config.getDouble("economy.cost." + type, 0.0);
        if (cost <= 0.0) {
            return true;
        }
        if (!this.econ.has((OfflinePlayer)p, cost)) {
            this.send(p, "not-enough-money", Map.of("cost", String.valueOf(cost)));
            return false;
        }
        this.econ.withdrawPlayer((OfflinePlayer)p, cost);
        req.cost = cost;
        return true;
    }

    private void refund(TpaRequest req, String type) {
        boolean refund;
        if (!this.config.getBoolean("economy.enabled")) {
            return;
        }
        if (this.econ == null) {
            return;
        }
        if (req.cost <= 0.0) {
            return;
        }
        boolean bl = refund = "deny".equals(type) && this.config.getBoolean("economy.refund-on-deny") || "expire".equals(type) && this.config.getBoolean("economy.refund-on-expire");
        if (!refund) {
            return;
        }
        try {
            this.econ.depositPlayer((OfflinePlayer)req.sender, req.cost);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.cost = 0.0;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String name;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Players only!");
            return true;
        }
        Player p = (Player)sender;
        boolean bypassCooldown = p.hasPermission("tpa.bypass.cooldown");
        if (!bypassCooldown && this.isOnCooldown(p)) {
            this.send(p, "cooldown", null);
            return true;
        }
        switch (name = cmd.getName().toLowerCase()) {
            case "tpa": {
                if (args.length == 0) {
                    return false;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (!this.validateRequest(p, target)) {
                    return true;
                }
                TpaRequest req = new TpaRequest(p, target, false);
                if (!this.charge(p, "tpa", req)) {
                    return true;
                }
                this.addRequestForTarget(target.getUniqueId(), req);
                this.send(p, "request-sent", Map.of("player", target.getName()));
                this.send(target, "request-received", Map.of("player", p.getName()));
                this.playSound(target, "request");
                req.startTimeout();
                this.setCooldown(p);
                break;
            }
            case "tpahere": {
                if (args.length == 0) {
                    return false;
                }
                Player hereTarget = Bukkit.getPlayer((String)args[0]);
                if (!this.validateRequest(p, hereTarget)) {
                    return true;
                }
                TpaRequest hereReq = new TpaRequest(p, hereTarget, true);
                if (!this.charge(p, "tpahere", hereReq)) {
                    return true;
                }
                this.addRequestForTarget(hereTarget.getUniqueId(), hereReq);
                this.send(p, "request-sent-here", Map.of("player", hereTarget.getName()));
                this.send(hereTarget, "request-received-here", Map.of("player", p.getName()));
                this.playSound(hereTarget, "request");
                hereReq.startTimeout();
                this.setCooldown(p);
                break;
            }
            case "tpaccept": {
                if (args.length == 0) {
                    List<TpaRequest> list = this.requests.get(p.getUniqueId());
                    if (list == null || list.isEmpty()) {
                        this.send(p, "no-request", null);
                        return true;
                    }
                    TpaRequest toAccept = list.remove(list.size() - 1);
                    if (list.isEmpty()) {
                        this.requests.remove(p.getUniqueId());
                    }
                    toAccept.accept();
                    break;
                }
                String who = args[0];
                TpaRequest found = this.findRequestBySenderName(p.getUniqueId(), who);
                if (found == null) {
                    this.send(p, "no-request-from-player", Map.of("player", who));
                    return true;
                }
                this.removeRequest(found);
                found.accept();
                break;
            }
            case "tpdeny": {
                if (args.length == 0) {
                    List<TpaRequest> list = this.requests.get(p.getUniqueId());
                    if (list == null || list.isEmpty()) {
                        this.send(p, "no-request", null);
                        return true;
                    }
                    TpaRequest toDeny = list.remove(list.size() - 1);
                    if (list.isEmpty()) {
                        this.requests.remove(p.getUniqueId());
                    }
                    toDeny.deny();
                    break;
                }
                TpaRequest found = this.findRequestBySenderName(p.getUniqueId(), args[0]);
                if (found == null) {
                    this.send(p, "no-request-from-player", Map.of("player", args[0]));
                    return true;
                }
                this.removeRequest(found);
                found.deny();
                break;
            }
            case "tpacancel": {
                if (args.length == 0) {
                    this.cancelAllRequestsFromSender(p);
                    break;
                }
                this.cancelRequestsFromSenderToTarget(p, args[0]);
                break;
            }
            case "tpall": {
                TpaRequest allReq = new TpaRequest(p, null, true);
                if (!this.charge(p, "tpall", allReq)) {
                    return true;
                }
                int sent = 0;
                for (Player all : Bukkit.getOnlinePlayers()) {
                    if (all.equals((Object)p) || this.tpaToggle.contains(all.getUniqueId())) continue;
                    TpaRequest reqAll = new TpaRequest(p, all, true);
                    reqAll.cost = 0.0;
                    this.addRequestForTarget(all.getUniqueId(), reqAll);
                    this.send(all, "request-received-all", Map.of("player", p.getName()));
                    this.playSound(all, "request");
                    reqAll.startTimeout();
                    ++sent;
                }
                this.send(p, "request-sent-all", Map.of("count", String.valueOf(sent)));
                this.setCooldown(p);
                break;
            }
            case "tpatoggle": {
                if (this.tpaToggle.contains(p.getUniqueId())) {
                    this.tpaToggle.remove(p.getUniqueId());
                    this.send(p, "toggle-off", null);
                    break;
                }
                this.tpaToggle.add(p.getUniqueId());
                this.send(p, "toggle-on", null);
                break;
            }
            case "tpainfo": {
                List<TpaRequest> infoList = this.requests.get(p.getUniqueId());
                if (infoList == null || infoList.isEmpty()) {
                    this.send(p, "no-request", null);
                    break;
                }
                TpaRequest last = infoList.get(infoList.size() - 1);
                this.send(p, "request-info", Map.of("player", last.sender.getName(), "type", last.here ? "TPAHere" : "TPA"));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void addRequestForTarget(UUID target, TpaRequest req) {
        this.requests.computeIfAbsent(target, k -> Collections.synchronizedList(new ArrayList())).add(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TpaRequest findRequestBySenderName(UUID targetUuid, String senderName) {
        List<TpaRequest> list = this.requests.get(targetUuid);
        if (list == null) {
            return null;
        }
        List<TpaRequest> list2 = list;
        synchronized (list2) {
            for (TpaRequest r : list) {
                if (!r.sender.getName().equalsIgnoreCase(senderName)) continue;
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequest(TpaRequest req) {
        UUID target;
        UUID uUID = target = req.target == null ? null : req.target.getUniqueId();
        if (target == null) {
            return;
        }
        List<TpaRequest> list = this.requests.get(target);
        if (list == null) {
            return;
        }
        List<TpaRequest> list2 = list;
        synchronized (list2) {
            list.remove(req);
            if (list.isEmpty()) {
                this.requests.remove(target);
            }
        }
    }

    private void cancelAllRequestsFromSender(Player sender) {
        this.requests.forEach((target, list) -> {
            List list2 = list;
            synchronized (list2) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    TpaRequest r = (TpaRequest)it.next();
                    if (!r.sender.equals((Object)sender)) continue;
                    it.remove();
                    this.send(sender, "request-cancelled", Map.of("player", r.target == null ? "ALL" : r.target.getName()));
                    if (r.target != null) {
                        this.send(r.target, "request-cancelled-target", Map.of("player", sender.getName()));
                    }
                    this.refund(r, "expire");
                }
            }
            if (list.isEmpty()) {
                this.requests.remove(target);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRequestsFromSenderToTarget(Player sender, String targetName) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.send(sender, "no-player", null);
            return;
        }
        List<TpaRequest> list = this.requests.get(target.getUniqueId());
        if (list == null) {
            this.send(sender, "no-request", null);
            return;
        }
        List<TpaRequest> list2 = list;
        synchronized (list2) {
            Iterator<TpaRequest> it = list.iterator();
            while (it.hasNext()) {
                TpaRequest r = it.next();
                if (!r.sender.equals((Object)sender)) continue;
                it.remove();
                this.send(sender, "request-cancelled", Map.of("player", target.getName()));
                this.send(target, "request-cancelled-target", Map.of("player", sender.getName()));
                this.refund(r, "expire");
            }
            if (list.isEmpty()) {
                this.requests.remove(target.getUniqueId());
            }
        }
    }

    private boolean validateRequest(Player sender, Player target) {
        if (target == null || !target.isOnline()) {
            this.send(sender, "no-player", null);
            return false;
        }
        if (this.tpaToggle.contains(target.getUniqueId())) {
            this.send(sender, "target-toggled", Map.of("player", target.getName()));
            return false;
        }
        if (!this.config.getBoolean("restrictions.cross-world", false) && !sender.getWorld().equals((Object)target.getWorld())) {
            this.send(sender, "crossworld-disabled", null);
            return false;
        }
        if (this.config.getStringList("restrictions.blocked-worlds").contains(target.getWorld().getName())) {
            this.send(sender, "blocked-world", null);
            return false;
        }
        return true;
    }

    private boolean isOnCooldown(Player p) {
        long now = System.currentTimeMillis();
        int cd = this.getInt("cooldown", 0);
        if (!this.cooldowns.containsKey(p.getUniqueId())) {
            return false;
        }
        return now - this.cooldowns.get(p.getUniqueId()) < (long)cd * 1000L;
    }

    private void setCooldown(Player p) {
        this.cooldowns.put(p.getUniqueId(), System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        boolean moved;
        Player player = e.getPlayer();
        boolean blockLevel = this.config.getBoolean("settings.block-move-threshold-blocks", true);
        if (blockLevel) {
            moved = !e.getFrom().getBlock().equals((Object)e.getTo().getBlock());
        } else {
            boolean bl = moved = !e.getFrom().toVector().equals((Object)e.getTo().toVector());
        }
        if (!moved) {
            return;
        }
        List<TpaRequest> list = this.requests.get(player.getUniqueId());
        if (list == null) {
            return;
        }
        List<TpaRequest> list2 = list;
        synchronized (list2) {
            for (TpaRequest req : list) {
                if (!req.inWarmup || !this.config.getBoolean("settings.cancel-on-move", true)) continue;
                this.send(player, "teleport-cancelled-move", null);
                req.cancelWarmup();
            }
        }
    }

    private class TpaRequest {
        private final Player sender;
        private final Player target;
        private final boolean here;
        private boolean inWarmup = false;
        private double cost = 0.0;
        private Integer timeoutTaskId = null;
        private Integer warmupTaskId = null;

        TpaRequest(Player sender, Player target, boolean here) {
            this.sender = sender;
            this.target = target;
            this.here = here;
        }

        void startTimeout() {
            int timeout = Math.max(1, TPA.this.getInt("timeout", 60));
            this.timeoutTaskId = new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (TpaRequest.this.target == null) {
                        return;
                    }
                    List<TpaRequest> list = TPA.this.requests.get(TpaRequest.this.target.getUniqueId());
                    if (list == null) {
                        return;
                    }
                    List<TpaRequest> list2 = list;
                    synchronized (list2) {
                        if (list.remove(TpaRequest.this)) {
                            if (list.isEmpty()) {
                                TPA.this.requests.remove(TpaRequest.this.target.getUniqueId());
                            }
                            TPA.this.send(TpaRequest.this.sender, "request-expired", Map.of("player", TpaRequest.this.target.getName()));
                            TPA.this.send(TpaRequest.this.target, "request-expired-target", Map.of("player", TpaRequest.this.sender.getName()));
                            TPA.this.refund(TpaRequest.this, "expire");
                        }
                    }
                }
            }.runTaskLater((Plugin)TPA.this.plugin, (long)timeout * 20L).getTaskId();
        }

        void accept() {
            if (this.timeoutTaskId != null) {
                Bukkit.getScheduler().cancelTask(this.timeoutTaskId.intValue());
            }
            final int warmup = Math.max(0, TPA.this.getInt("warmup", 0));
            final int delay = Math.max(0, TPA.this.getInt("teleport-delay", 3));
            TPA.this.send(this.sender, "request-accepted", Map.of("player", this.target == null ? "ALL" : this.target.getName()));
            if (this.target != null) {
                TPA.this.send(this.target, "request-accepted-target", Map.of("player", this.sender.getName()));
            }
            TPA.this.playSound(this.sender, "accept");
            if (this.target != null) {
                TPA.this.playSound(this.target, "accept");
            }
            this.warmupTaskId = new BukkitRunnable(){

                public void run() {
                    TpaRequest.this.inWarmup = true;
                    new BukkitRunnable(){

                        public void run() {
                            try {
                                if (TpaRequest.this.target == null) {
                                    return;
                                }
                                if (TpaRequest.this.here) {
                                    TpaRequest.this.target.teleport(TpaRequest.this.sender.getLocation());
                                } else {
                                    TpaRequest.this.sender.teleport(TpaRequest.this.target.getLocation());
                                }
                                if (TPA.this.config.getBoolean("particles.enabled", true)) {
                                    Location loc = TpaRequest.this.here ? TpaRequest.this.sender.getLocation() : TpaRequest.this.target.getLocation();
                                    Particle pType = Particle.valueOf((String)TPA.this.config.getString("particles.type", "PORTAL"));
                                    loc.getWorld().spawnParticle(pType, loc, 50, 1.0, 1.0, 1.0);
                                }
                                TPA.this.playSound(TpaRequest.this.sender, "teleport");
                                if (TpaRequest.this.target != null) {
                                    TPA.this.playSound(TpaRequest.this.target, "teleport");
                                }
                            }
                            catch (Exception ex) {
                                Bukkit.getLogger().warning("Failed to teleport during TPA: " + ex.getMessage());
                            }
                            finally {
                                TpaRequest.this.inWarmup = false;
                                TpaRequest.this.warmupTaskId = null;
                            }
                        }
                    }.runTaskLater((Plugin)TPA.this.plugin, (long)(warmup + delay) * 20L);
                }
            }.runTask((Plugin)TPA.this.plugin).getTaskId();
        }

        void cancelWarmup() {
            this.inWarmup = false;
            if (this.warmupTaskId != null) {
                Bukkit.getScheduler().cancelTask(this.warmupTaskId.intValue());
                this.warmupTaskId = null;
            }
        }

        void deny() {
            if (this.timeoutTaskId != null) {
                Bukkit.getScheduler().cancelTask(this.timeoutTaskId.intValue());
            }
            TPA.this.send(this.sender, "request-denied", Map.of("player", this.target == null ? "ALL" : this.target.getName()));
            if (this.target != null) {
                TPA.this.send(this.target, "request-denied-target", Map.of("player", this.sender.getName()));
            }
            TPA.this.playSound(this.sender, "deny");
            if (this.target != null) {
                TPA.this.playSound(this.target, "deny");
            }
            TPA.this.refund(this, "deny");
        }
    }
}

