/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TopCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public TopCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("Top.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        boolean teleported = false;
        for (int y = 255; y > loc.getBlockY(); --y) {
            Location check = new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
            if (check.getBlock().getType() == Material.AIR) continue;
            player.teleport(check.add(0.0, 1.0, 0.0));
            Component successMsg = this.messages.get("Top.teleported", new String[0]);
            player.sendMessage(successMsg);
            teleported = true;
            break;
        }
        if (!teleported) {
            Component failMsg = this.messages.get("Top.no-block", new String[0]);
            player.sendMessage(failMsg);
        }
        return true;
    }
}

