/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.Player.ReportManager;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ReportsListCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;
    private final ReportManager manager;

    public ReportsListCommand(ServerEssentials plugin, PlayerMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
        this.manager = new ReportManager(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.report.admin")) {
            sender.sendMessage(this.messages.get("report.no-permission", new String[0]));
            return true;
        }
        this.manager.reload();
        Map<String, Map<String, Object>> reports = this.manager.getAllReports();
        if (reports.isEmpty()) {
            sender.sendMessage(this.messages.get("reports.none", new String[0]));
            return true;
        }
        sender.sendMessage(this.messages.get("reports.header", new String[0]));
        for (Map.Entry<String, Map<String, Object>> e : reports.entrySet()) {
            String id = e.getKey();
            Map<String, Object> m = e.getValue();
            String reporterUuidStr = (String)m.get("reporter");
            String targetUuidStr = (String)m.get("target");
            String reason = (String)m.get("reason");
            String reporterName = "Unknown";
            String targetName = "Unknown";
            try {
                if (reporterUuidStr != null) {
                    reporterName = Bukkit.getOfflinePlayer((UUID)UUID.fromString(reporterUuidStr)).getName();
                }
                if (targetUuidStr != null) {
                    targetName = Bukkit.getOfflinePlayer((UUID)UUID.fromString(targetUuidStr)).getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Component line = this.messages.get("reports.entry", "{id}", id, "{reporter}", reporterName != null ? reporterName : "Unknown", "{target}", targetName != null ? targetName : "Unknown", "{reason}", reason != null ? reason : "No reason");
            sender.sendMessage(line);
        }
        sender.sendMessage(this.messages.get("reports.footer", new String[0]));
        return true;
    }
}

