/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NearCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public NearCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("Near.Messages.PlayerOnly", "<red>Only players can use this command.");
        messages.addDefault("Near.Messages.Header", "<green>Players near you:");
        messages.addDefault("Near.Messages.Entry", "<yellow>- <name> <gray>(<distance> blocks)");
        messages.addDefault("Near.Messages.None", "<red>No players are nearby.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Near.Messages.PlayerOnly", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        player.sendMessage(this.messages.get("Near.Messages.Header", new String[0]));
        boolean found = false;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.equals((Object)player) || !(p.getLocation().distance(loc) <= 20.0)) continue;
            found = true;
            String entry = this.messages.getConfig().getString("Near.Messages.Entry", "- <name> (<distance> blocks)").replace("<name>", p.getName()).replace("<distance>", String.valueOf((int)p.getLocation().distance(loc)));
            player.sendMessage(this.miniMessage.deserialize(entry));
        }
        if (!found) {
            player.sendMessage(this.messages.get("Near.Messages.None", new String[0]));
        }
        return true;
    }
}

