/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MailCommand
implements CommandExecutor,
TabCompleter,
Listener {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;
    private final File mailFile;
    private FileConfiguration mailConfig;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();

    public MailCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.messages = plugin.getPlayerMessages();
        this.mailFile = new File(plugin.getDataFolder(), "storage/mails.yml");
        this.createFileIfNotExists();
        this.reloadMail();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startAutoSaveTask();
    }

    private void createFileIfNotExists() {
        if (!this.mailFile.getParentFile().exists()) {
            this.mailFile.getParentFile().mkdirs();
        }
        if (!this.mailFile.exists()) {
            try {
                this.mailFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create mails.yml!");
                e.printStackTrace();
            }
        }
    }

    public void reloadMail() {
        this.mailConfig = YamlConfiguration.loadConfiguration((File)this.mailFile);
    }

    public void saveMailAsync() {
        new BukkitRunnable(){

            public void run() {
                try {
                    MailCommand.this.mailConfig.save(MailCommand.this.mailFile);
                }
                catch (IOException e) {
                    MailCommand.this.plugin.getLogger().severe("Failed to save mails.yml!");
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void startAutoSaveTask() {
        new BukkitRunnable(){

            public void run() {
                MailCommand.this.saveMailAsync();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Mail.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendUsage(player);
            return true;
        }
        return switch (sub = args[0].toLowerCase()) {
            case "read" -> this.readMail(player);
            case "send" -> this.sendMail(player, args);
            case "clear" -> this.clearMail(player);
            default -> {
                this.sendUsage(player);
                yield true;
            }
        };
    }

    private boolean readMail(Player player) {
        UUID uuid = player.getUniqueId();
        List inbox = this.mailConfig.getStringList(uuid.toString());
        if (inbox.isEmpty()) {
            player.sendMessage(this.messages.get("Mail.no-mail", new String[0]));
            return true;
        }
        player.sendMessage(this.messages.get("Mail.header", new String[0]));
        int index = 1;
        for (String plain : inbox) {
            Component coloured = this.messages.get("Mail.message-index", "{index}", String.valueOf(index++)).append(Component.space()).append(LegacyComponentSerializer.legacyAmpersand().deserialize(plain));
            player.sendMessage(coloured);
        }
        player.sendMessage(this.messages.get("Mail.footer", "{count}", String.valueOf(inbox.size())));
        return true;
    }

    private boolean sendMail(Player sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(this.messages.get("Mail.send-usage", new String[0]));
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Bukkit.getOfflinePlayerIfCached((String)targetName);
        if (target == null || target.getName() == null) {
            sender.sendMessage(this.messages.get("Mail.player-not-found", "{target}", targetName));
            return true;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String plain = LegacyComponentSerializer.legacySection().serialize(Component.text(message));
        UUID targetUUID = target.getUniqueId();
        List inbox = this.mailConfig.getStringList(targetUUID.toString());
        inbox.add(plain);
        this.mailConfig.set(targetUUID.toString(), (Object)inbox);
        this.saveMailAsync();
        Component coloured = this.messages.get("Mail.format", "{sender}", sender.getName(), "{message}", message);
        sender.sendMessage(this.messages.get("Mail.sent", "{target}", target.getName()));
        Player onlineTarget = target.getPlayer();
        if (onlineTarget != null && onlineTarget.isOnline()) {
            onlineTarget.sendMessage(this.messages.get("Mail.received", "{sender}", sender.getName()));
            this.notifiedPlayers.remove(targetUUID);
        }
        return true;
    }

    private boolean clearMail(Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.mailConfig.contains(uuid.toString()) || this.mailConfig.getStringList(uuid.toString()).isEmpty()) {
            player.sendMessage(this.messages.get("Mail.no-mail", new String[0]));
            return true;
        }
        this.mailConfig.set(uuid.toString(), new ArrayList());
        this.saveMailAsync();
        player.sendMessage(this.messages.get("Mail.cleared", new String[0]));
        return true;
    }

    private void sendUsage(Player player) {
        List<String> helpLines = Arrays.asList("<#4CAF50>-----<#808080>[ <#FFFFFF>Mail Help <#808080>]<#4CAF50>-----", "<#67D2F5>/mail read <#808080>- <#FFFFFF>Read your inbox", "<#67D2F5>/mail send <player> <msg> <#808080>- <#FFFFFF>Send a mail", "<#67D2F5>/mail clear <#808080>- <#FFFFFF>Clear all mail", "<#4CAF50>------------------------------");
        helpLines.forEach(line -> player.sendMessage(this.messages.get("Mail.dummy", "{line}", (String)line)));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        final UUID uuid = player.getUniqueId();
        new BukkitRunnable(){

            public void run() {
                List inbox = MailCommand.this.mailConfig.getStringList(uuid.toString());
                if (!inbox.isEmpty() && MailCommand.this.notifiedPlayers.add(uuid)) {
                    player.sendMessage(MailCommand.this.messages.get("Mail.on-join", "{count}", String.valueOf(inbox.size())));
                }
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("read", "send", "clear").stream().filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2 && "send".equalsIgnoreCase(args[0])) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
        }
        return Collections.emptyList();
    }
}

