/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class IgnoreCommand
implements CommandExecutor,
Listener {
    private final Map<UUID, Set<UUID>> ignoredPlayers = new HashMap<UUID, Set<UUID>>();
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private File file;
    private FileConfiguration config;

    public IgnoreCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("Ignore.Messages.PlayerOnly", "<red>Only players can use this command.");
        messages.addDefault("Ignore.Messages.Usage", "<red>Usage: /ignore <player>");
        messages.addDefault("Ignore.Messages.NotFound", "<red>Player not found!");
        messages.addDefault("Ignore.Messages.Self", "<red>You cannot ignore yourself!");
        messages.addDefault("Ignore.Messages.Add", "<green>You are now ignoring <yellow><player><green>.");
        messages.addDefault("Ignore.Messages.Remove", "<green>You are no longer ignoring <yellow><player><green>.");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ServerEssentials.getInstance());
        this.loadIgnoredPlayers();
    }

    private void loadIgnoredPlayers() {
        this.file = new File(ServerEssentials.getInstance().getDataFolder(), "storage/ignoredplayers.yml");
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String key : this.config.getKeys(false)) {
            UUID playerUUID = UUID.fromString(key);
            HashSet<UUID> ignoredSet = new HashSet<UUID>();
            for (String ignoredUUID : this.config.getStringList(key)) {
                ignoredSet.add(UUID.fromString(ignoredUUID));
            }
            this.ignoredPlayers.put(playerUUID, ignoredSet);
        }
    }

    private void saveIgnoredPlayers() {
        for (UUID playerUUID : this.ignoredPlayers.keySet()) {
            Set<UUID> ignoredSet = this.ignoredPlayers.get(playerUUID);
            HashSet<String> ignoredStrings = new HashSet<String>();
            for (UUID ignoredUUID : ignoredSet) {
                ignoredStrings.add(ignoredUUID.toString());
            }
            this.config.set(playerUUID.toString(), new ArrayList(ignoredStrings));
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isIgnoring(Player player, Player target) {
        IgnoreCommand instance = ServerEssentials.getInstance().getIgnoreCommand();
        Set<UUID> ignoredSet = instance.ignoredPlayers.get(player.getUniqueId());
        return ignoredSet != null && ignoredSet.contains(target.getUniqueId());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Ignore.Messages.PlayerOnly", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.messages.get("Ignore.Messages.Usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.messages.get("Ignore.Messages.NotFound", new String[0]));
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(this.messages.get("Ignore.Messages.Self", new String[0]));
            return true;
        }
        Set ignoredSet = this.ignoredPlayers.getOrDefault(player.getUniqueId(), new HashSet());
        String removeMsg = this.messages.getConfig().getString("Ignore.Messages.Remove", "<green>You are no longer ignoring <yellow><player><green>.").replace("<player>", target.getName());
        player.sendMessage(this.miniMessage.deserialize(removeMsg));
        String addMsg = this.messages.getConfig().getString("Ignore.Messages.Add", "<green>You are now ignoring <yellow><player><green>.").replace("<player>", target.getName());
        player.sendMessage(this.miniMessage.deserialize(addMsg));
        this.ignoredPlayers.put(player.getUniqueId(), ignoredSet);
        this.saveIgnoredPlayers();
        return true;
    }
}

