/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ExtCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public ExtCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.messages.addDefault("ext.only-players", "<red>Only players can use this command!");
        this.messages.addDefault("ext.player-not-found", "<red>Player not found!");
        this.messages.addDefault("ext.self", "<green>You have been extinguished!");
        this.messages.addDefault("ext.target", "<green>You extinguished {target}!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("ext.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            target = player;
        } else {
            target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage(this.messages.get("ext.player-not-found", new String[0]));
                return true;
            }
        }
        target.setFireTicks(0);
        target.sendMessage(this.messages.get("ext.self", new String[0]));
        if (!target.equals((Object)player)) {
            player.sendMessage(this.messages.get("ext.target", "{target}", target.getName()));
        }
        return true;
    }
}

