/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BurnCommand
implements CommandExecutor {
    private final PlayerMessages playerMessages;

    public BurnCommand(PlayerMessages playerMessages) {
        this.playerMessages = playerMessages;
        playerMessages.addDefault("burn.no_permission", "<red>You do not have permission.");
        playerMessages.addDefault("burn.usage", "<red>Usage: /burn <player> [seconds]");
        playerMessages.addDefault("burn.player_not_found", "<red>Player not found.");
        playerMessages.addDefault("burn.immune_gamemode", "<red>That player is in a game mode that is immune to fire.");
        playerMessages.addDefault("burn.invalid_number", "<red>Invalid number.");
        playerMessages.addDefault("burn.target_burned", "<red>You have been set on fire by <yellow>{sender}</yellow>!");
        playerMessages.addDefault("burn.sender_burned", "<yellow>{target}</yellow><red> has been set on fire for <yellow>{seconds}</yellow> seconds.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.burn")) {
            sender.sendMessage(this.playerMessages.get("burn.no_permission", new String[0]));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.playerMessages.get("burn.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.playerMessages.get("burn.player_not_found", new String[0]));
            return true;
        }
        if (target.getGameMode() == GameMode.CREATIVE || target.getGameMode() == GameMode.SPECTATOR) {
            sender.sendMessage(this.playerMessages.get("burn.immune_gamemode", new String[0]));
            return true;
        }
        int seconds = 5;
        if (args.length == 2) {
            try {
                seconds = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.playerMessages.get("burn.invalid_number", new String[0]));
                return true;
            }
        }
        target.setFireTicks(seconds * 20);
        target.sendMessage(this.playerMessages.get("burn.target_burned", "{sender}", sender.getName()));
        sender.sendMessage(this.playerMessages.get("burn.sender_burned", "{target}", target.getName(), "{seconds}", String.valueOf(seconds)));
        return true;
    }
}

