/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BookCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("Book.Messages.PlayerOnly", "<red>Only players can use this command.");
        messages.addDefault("Book.Messages.NoPermission", "<red>You do not have permission to use this command.");
        messages.addDefault("Book.Messages.Success", "<green>Book added to your inventory!");
        messages.addDefault("Book.Title", "ServerEssentials");
        messages.addDefault("Book.Author", "SE Plugin");
        messages.addDefault("Book.Pages", String.valueOf(List.of("This is a sample book!")));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Book.Messages.PlayerOnly", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.book")) {
            player.sendMessage(this.messages.get("Book.Messages.NoPermission", new String[0]));
            return true;
        }
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        String title = this.messages.getConfig().getString("Book.Title", "ServerEssentials");
        String author = this.messages.getConfig().getString("Book.Author", "SE Plugin");
        List pages = this.messages.getConfig().getStringList("Book.Pages");
        meta.setTitle(title);
        meta.setAuthor(author);
        for (String page : pages) {
            meta.addPage(new String[]{this.miniMessage.deserialize(page).toString()});
        }
        book.setItemMeta((ItemMeta)meta);
        player.getInventory().addItem(new ItemStack[]{book});
        player.sendMessage(this.messages.get("Book.Messages.Success", new String[0]));
        return true;
    }
}

