/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lunark.io.Managers.BackManager;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BackCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerMessages messages;

    public BackCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("Back.no-permission", "<red>You don't have permission to use this command.");
        messages.addDefault("Back.no-back", "<red>No previous location saved.");
        messages.addDefault("Back.invalid-back", "<red>Your last location is invalid.");
        messages.addDefault("Back.teleported-back", "<green>Teleported back to your previous location.");
        messages.addDefault("Back.lobby-not-set", "<red>Lobby location not set.");
        messages.addDefault("Back.teleported-lobby", "<green>Teleported to the lobby.");
        messages.addDefault("Back.no-death-location", "<red>No death location found.");
        messages.addDefault("Back.teleported-death", "<green>Teleported to your last death location.");
        messages.addDefault("Back.unknown-usage", "<red>Unknown command. Use: /back, /back lobby, /back death.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (args.length == 0) {
            if (!player.hasPermission("serveressentials.back.last")) {
                player.sendMessage(this.messages.get("Back.no-permission", new String[0]));
                return true;
            }
            return this.teleportToBack(player, uuid);
        }
        switch (args[0].toLowerCase()) {
            case "lobby": {
                if (!player.hasPermission("serveressentials.back.lobby")) {
                    player.sendMessage(this.messages.get("Back.no-permission", new String[0]));
                    return true;
                }
                Location lobbyLocation = this.getLobbyLocation();
                if (lobbyLocation == null) {
                    player.sendMessage(this.messages.get("Back.lobby-not-set", new String[0]));
                    return true;
                }
                player.teleport(lobbyLocation);
                player.sendMessage(this.messages.get("Back.teleported-lobby", new String[0]));
                break;
            }
            case "death": {
                if (!player.hasPermission("serveressentials.back.death")) {
                    player.sendMessage(this.messages.get("Back.no-permission", new String[0]));
                    return true;
                }
                Location deathLocation = player.getLastDeathLocation();
                if (deathLocation == null) {
                    player.sendMessage(this.messages.get("Back.no-death-location", new String[0]));
                    return true;
                }
                player.teleport(deathLocation);
                player.sendMessage(this.messages.get("Back.teleported-death", new String[0]));
                break;
            }
            case "back": {
                if (!player.hasPermission("serveressentials.back.last")) {
                    player.sendMessage(this.messages.get("Back.no-permission", new String[0]));
                    return true;
                }
                this.teleportToBack(player, uuid);
                break;
            }
            default: {
                player.sendMessage(this.messages.get("Back.unknown-usage", new String[0]));
            }
        }
        return true;
    }

    private boolean teleportToBack(Player player, UUID uuid) {
        if (!BackManager.hasBack(uuid)) {
            player.sendMessage(this.messages.get("Back.no-back", new String[0]));
            return true;
        }
        Location backLocation = BackManager.getLastLocation(uuid);
        if (backLocation == null) {
            player.sendMessage(this.messages.get("Back.invalid-back", new String[0]));
            return true;
        }
        player.teleport(backLocation);
        player.sendMessage(this.messages.get("Back.teleported-back", new String[0]));
        BackManager.clearBack(uuid);
        return true;
    }

    private Location getLobbyLocation() {
        return new Location(Bukkit.getWorld((String)"world"), 0.0, 100.0, 0.0);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (player.hasPermission("serveressentials.back.lobby")) {
                completions.add("lobby");
            }
            if (player.hasPermission("serveressentials.back.death")) {
                completions.add("death");
            }
            if (player.hasPermission("serveressentials.back.last")) {
                completions.add("back");
            }
        }
        return completions;
    }
}

