/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.lunark.io.ServerEssentials;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SessionManager {
    private final ServerEssentials plugin;
    private final File file;
    private FileConfiguration config;
    private final HashMap<UUID, Long> currentSessions = new HashMap();
    private final HashMap<UUID, Long> longestSessions = new HashMap();

    public SessionManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "storage/session.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadLongestSessions();
    }

    private void loadLongestSessions() {
        for (String uuidStr : this.config.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            this.longestSessions.put(uuid, this.config.getLong(uuidStr, 0L));
        }
    }

    public void startSession(Player player) {
        this.currentSessions.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void endSession(Player player) {
        UUID uuid = player.getUniqueId();
        Long startTime = this.currentSessions.get(uuid);
        if (startTime == null) {
            return;
        }
        long duration = System.currentTimeMillis() - startTime;
        this.currentSessions.remove(uuid);
        long previousLongest = this.longestSessions.getOrDefault(uuid, 0L);
        if (duration > previousLongest) {
            this.longestSessions.put(uuid, duration);
            this.save();
        }
    }

    public long getCurrentSession(Player player) {
        Long startTime = this.currentSessions.get(player.getUniqueId());
        if (startTime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    public long getLongestSession(Player player) {
        UUID uuid = player.getUniqueId();
        long current = this.getCurrentSession(player);
        long longest = this.longestSessions.getOrDefault(uuid, 0L);
        return Math.max(current, longest);
    }

    private void save() {
        for (UUID uuid : this.longestSessions.keySet()) {
            this.config.set(uuid.toString(), (Object)this.longestSessions.get(uuid));
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

