/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.io.File;
import net.lunark.io.Managers.AFKManager;
import net.lunark.io.Managers.ConsoleCommandManager;
import net.lunark.io.Managers.JoinLeaveManager;
import net.lunark.io.Managers.RulesManager;
import net.lunark.io.ServerEssentials;
import net.lunark.io.TPA.TPA;
import net.lunark.io.auction.AuctionMessagesManager;
import net.lunark.io.config.RTPConfig;
import net.lunark.io.economy.EconomyMessagesManager;
import net.lunark.io.economy.ShopGUIManager;
import net.lunark.io.kit.KitManager;
import net.lunark.io.lobby.LobbyManager;
import net.lunark.io.lobby.LobbyMessages;
import net.lunark.io.nick.NickManager;
import net.lunark.io.scoreboard.CustomScoreboardManager;
import net.lunark.io.staff.BanManager;
import net.lunark.io.util.DailyMessagesManager;
import net.lunark.io.util.DailyRewardsManager;
import net.lunark.io.util.FunMessages;
import net.lunark.io.util.HomeMessages;
import net.lunark.io.util.KitMessages;
import net.lunark.io.util.MessagesManager;
import net.lunark.io.util.PlayerMessages;
import net.lunark.io.util.RTPMessages;
import net.lunark.io.util.ReloadUtils;
import net.lunark.io.util.ServerMessages;
import net.lunark.io.util.VaultMessages;
import net.lunark.io.util.WarpMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class ReloadManager {
    private static ReloadManager instance;
    private final ServerEssentials plugin;

    public ReloadManager(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static ReloadManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ReloadManager has not been initialized yet!");
        }
        return instance;
    }

    public static void reloadAll(CommandSender sender) {
        ReloadManager.getInstance().reloadEverything(sender);
    }

    public void reloadEverything(CommandSender sender) {
        long start = System.currentTimeMillis();
        File dataFolder = this.plugin.getDataFolder();
        this.plugin.reloadConfig();
        KitManager.reload();
        ShopGUIManager.reload(this.plugin.getDataFolder());
        ShopGUIManager.refreshOpenInventories();
        ShopGUIManager.sectionConfigs.clear();
        BanManager.reload();
        ConsoleCommandManager.reload();
        DailyRewardsManager.reload();
        JoinLeaveManager.reload();
        LobbyManager.reload();
        NickManager.reload();
        RTPConfig.fullReload();
        CustomScoreboardManager.reloadAll();
        RulesManager.reload();
        DailyMessagesManager.fullReload();
        EconomyMessagesManager.reload();
        FunMessages.reloadAll();
        HomeMessages.reloadAll();
        KitMessages.reloadAll();
        LobbyMessages.reload();
        PlayerMessages.reloadAll();
        VaultMessages.fullReload();
        WarpMessages.fullReload();
        ServerMessages.fullReload();
        MessagesManager.fullReload();
        ShopGUIManager.openSection.clear();
        RTPConfig.fullReload();
        RTPMessages.fullReload();
        AuctionMessagesManager.fullReload();
        LobbyManager.reload();
        TPA.fullReload();
        ShopGUIManager.currentPage.clear();
        AFKManager.reload();
        this.plugin.getKitMessages().reload();
        ShopGUIManager.reload(this.plugin.getDataFolder());
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "config"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "messages"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "shop"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "storage"));
        for (String rootFile : new String[]{"Config.yml", "FJ.yml", "kits.yml", "placeholders.yml"}) {
            File file = new File(dataFolder, rootFile);
            if (!file.exists()) continue;
            ReloadUtils.reloadFile(file);
        }
        long elapsed = System.currentTimeMillis() - start;
        Bukkit.getLogger().info("[ServerEssentials] Reloaded all files in " + elapsed + "ms.");
    }
}

