/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JoinLeaveManager {
    private static File configFile;
    private static FileConfiguration config;

    public static void load() {
        File configFolder;
        File pluginFolder = Bukkit.getPluginManager().getPlugin("ServerEssentials").getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!(configFolder = new File(pluginFolder, "config/Join_Leave_Messages")).exists()) {
            configFolder.mkdirs();
        }
        if (!(configFile = new File(configFolder, "joinleave.yml")).exists()) {
            JoinLeaveManager.saveDefaultConfig();
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    private static void saveDefaultConfig() {
        try {
            configFile.createNewFile();
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((File)configFile);
            defaultConfig.set("join-message", (Object)"&8[&e+&8] &e%player%");
            defaultConfig.set("leave-message", (Object)"&8[&6-&8] &6%player%");
            defaultConfig.save(configFile);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[ServerEssentials] Could not create joinleave.yml!");
            e.printStackTrace();
        }
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void reload() {
        if (configFile == null) {
            JoinLeaveManager.load();
            return;
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!configFile.exists()) {
            JoinLeaveManager.saveDefaultConfig();
            config = YamlConfiguration.loadConfiguration((File)configFile);
        }
        Bukkit.getLogger().info("[ServerEssentials] JoinLeaveManager reloaded successfully.");
    }
}

