/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Fun;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.FunMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LightningCommand
implements CommandExecutor {
    private final FunMessages funMessages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public LightningCommand(FunMessages funMessages) {
        this.funMessages = funMessages;
        funMessages.addDefault("lightning.only-players", "<red>Only players can use this command!</red>");
        funMessages.addDefault("lightning.player-not-found", "<red>Player <white><target></white> not found.</red>");
        funMessages.addDefault("lightning.no-permission", "<red>You need the <white>serveressentials.lightning</white> permission.</red>");
        funMessages.addDefault("lightning.struck-self", "<green>Lightning struck!</green>");
        funMessages.addDefault("lightning.struck-other", "<green>Lightning struck <white><target></white>!</green>");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player player;
        String targetName;
        ArrayList<String> argv = new ArrayList<String>(List.of(args));
        boolean silent = argv.remove("-s");
        String string = targetName = argv.isEmpty() ? null : (String)argv.get(0);
        if (targetName == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.miniMessage.deserialize(this.funMessages.getConfig().getString("lightning.only-players")));
                return true;
            }
            Player p = (Player)sender;
            player = p;
        } else {
            player = sender.getServer().getPlayer(targetName);
            if (player == null || !player.isOnline()) {
                sender.sendMessage(this.miniMessage.deserialize(this.funMessages.getConfig().getString("lightning.player-not-found").replace("<target>", targetName)));
                return true;
            }
        }
        if (!sender.hasPermission("serveressentials.lightning")) {
            sender.sendMessage(this.miniMessage.deserialize(this.funMessages.getConfig().getString("lightning.no-permission")));
            return true;
        }
        Location loc = player.getLocation();
        World world = loc.getWorld();
        if (world == null) {
            return true;
        }
        Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("ServerEssentials"), () -> world.strikeLightning(loc));
        if (!silent) {
            String key = sender.equals((Object)player) ? "lightning.struck-self" : "lightning.struck-other";
            String msg = this.funMessages.getConfig().getString(key).replace("<target>", player.getName());
            sender.sendMessage(this.miniMessage.deserialize(msg));
        }
        return true;
    }
}

