/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Fun;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.FunMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ExplosionCommand
implements CommandExecutor,
TabCompleter {
    private final FunMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ExplosionCommand(FunMessages messages) {
        this.messages = messages;
        messages.addDefault("Explosion.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("Explosion.NoRadius", "<yellow>Please specify a radius!");
        messages.addDefault("Explosion.InvalidRadius", "<red>Invalid radius: {input}");
        messages.addDefault("Explosion.Created", "<green>Explosion created with radius {radius}!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Explosion.PlayerOnly"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(this.messages.get("Explosion.NoRadius"));
            return true;
        }
        try {
            float radius = Float.parseFloat(args[0]);
            player.getWorld().createExplosion(player.getLocation(), radius);
            player.sendMessage(this.miniMessage.deserialize(this.messages.getConfig().getString("Explosion.Created").replace("{radius}", args[0])));
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.miniMessage.deserialize(this.messages.getConfig().getString("Explosion.InvalidRadius").replace("{input}", args[0])));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (int i = 1; i <= 10; ++i) {
                suggestions.add(String.valueOf(i));
            }
            return suggestions;
        }
        return null;
    }
}

