/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Fun;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.FunMessages;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;

public final class CelebrateCommand
implements CommandExecutor {
    private final FunMessages funMessages;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private static final FireworkEffect EFFECT = FireworkEffect.builder().flicker(true).trail(true).with(FireworkEffect.Type.STAR).withColor(Color.fromRGB((int)5620906)).withFade(Color.fromRGB((int)0xAA88CC)).build();

    public CelebrateCommand(FunMessages funMessages) {
        this.funMessages = funMessages;
        funMessages.addDefault("celebrate.only-players", "<#55AA55>Only players can use this.");
        funMessages.addDefault("celebrate.player-not-found", "<#CC6B6B>Player not found.");
        funMessages.addDefault("celebrate.no-permission", "<#CC6B6B>Missing permission: <white>serveressentials.celebrate");
        funMessages.addDefault("celebrate.message", "<#88C488>\ud83c\udf89 Boom! Celebration!");
        funMessages.addDefault("celebrate.message-other", "<#88C488>\ud83c\udf89 Celebration for <white><target><#88C488>!");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player player;
        boolean silent = false;
        String targetName = null;
        for (String arg : args) {
            if (arg.equals("-s")) {
                silent = true;
                continue;
            }
            if (targetName != null) continue;
            targetName = arg;
        }
        if (targetName == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.mm.deserialize(this.funMessages.getConfig().getString("celebrate.only-players")));
                return true;
            }
            Player p = (Player)sender;
            player = p;
        } else {
            player = sender.getServer().getPlayer(targetName);
            if (player == null || !player.isOnline()) {
                sender.sendMessage(this.mm.deserialize(this.funMessages.getConfig().getString("celebrate.player-not-found")));
                return true;
            }
        }
        if (!sender.hasPermission("serveressentials.celebrate")) {
            sender.sendMessage(this.mm.deserialize(this.funMessages.getConfig().getString("celebrate.no-permission")));
            return true;
        }
        Location loc = player.getLocation();
        World world = loc.getWorld();
        if (world == null) {
            return true;
        }
        Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("ServerEssentials"), () -> {
            Firework fw = (Firework)world.spawnEntity(loc, EntityType.FIREWORK_ROCKET);
            FireworkMeta meta = fw.getFireworkMeta();
            meta.addEffect(EFFECT);
            meta.setPower(1);
            fw.setFireworkMeta(meta);
        });
        if (!silent) {
            String key = sender.equals((Object)player) ? "celebrate.message" : "celebrate.message-other";
            String raw = this.funMessages.getConfig().getString(key).replace("<target>", player.getName());
            sender.sendMessage(this.mm.deserialize(raw));
        }
        return true;
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            return (List)sender.getServer().getOnlinePlayers().stream().map(CommandSender::getName).filter(n -> n.regionMatches(true, 0, args[0], 0, args[0].length())).collect(ImmutableList.toImmutableList());
        }
        if (args.length == 2 && "-s".startsWith(args[1].toLowerCase())) {
            return ImmutableList.of((Object)"-s");
        }
        return ImmutableList.of();
    }
}

