/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service.message;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.service.MessageService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PaperMessageService
extends MessageService {
    protected final Pattern PARSED_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}");
    protected final LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.builder().character('&').hexColors().build();
    protected final MiniMessage miniMessage = MiniMessage.miniMessage();
    protected final Map<String, String> tags;

    public PaperMessageService(GSitMain gSitMain) {
        super(gSitMain);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("0", "<black>");
        tags.put("1", "<dark_blue>");
        tags.put("2", "<dark_green>");
        tags.put("3", "<dark_aqua>");
        tags.put("4", "<dark_red>");
        tags.put("5", "<dark_purple>");
        tags.put("6", "<gold>");
        tags.put("7", "<gray>");
        tags.put("8", "<dark_gray>");
        tags.put("9", "<blue>");
        tags.put("a", "<green>");
        tags.put("b", "<aqua>");
        tags.put("c", "<red>");
        tags.put("d", "<light_purple>");
        tags.put("e", "<yellow>");
        tags.put("f", "<white>");
        tags.put("k", "<obfuscated>");
        tags.put("l", "<bold>");
        tags.put("m", "<strikethrough>");
        tags.put("n", "<underlined>");
        tags.put("o", "<italic>");
        tags.put("r", "<reset>");
        this.tags = Collections.unmodifiableMap(tags);
    }

    @Override
    public String toFormattedMessage(String text, Object ... rawReplaceList) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.replaceHexColorsDirectly(this.formatText(text, rawReplaceList)));
    }

    @Override
    public void sendMessage(@NotNull CommandSender target, String message, Object ... replaceList) {
        Component translatedMessage = this.getTranslatedComponent(message, this.getLanguageForTarget(target), replaceList);
        if (translatedMessage.equals((Object)Component.empty())) {
            return;
        }
        target.sendMessage(translatedMessage);
    }

    @Override
    public void sendActionBarMessage(@NotNull Player target, String message, Object ... replaceList) {
        Component translatedMessage = this.getTranslatedComponent(message, this.getLanguageForTarget((CommandSender)target), replaceList);
        if (translatedMessage.equals((Object)Component.empty())) {
            return;
        }
        target.sendActionBar(translatedMessage);
    }

    @NotNull
    private Component getTranslatedComponent(String message, String languageCode, Object ... replaceList) {
        return this.toFormattedComponent(this.getRawTranslatedMessage(message, languageCode, replaceList), new Object[0]);
    }

    @NotNull
    private Component toFormattedComponent(String text, Object ... rawReplaceList) {
        return this.miniMessage.deserialize((Object)this.replaceLegacyColors(this.replaceText(text, rawReplaceList)));
    }

    private String replaceLegacyColors(String text) {
        Matcher matcher = this.HEX_PATTERN.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int lastIndex = 0;
        while (matcher.find()) {
            result.append(text, lastIndex, matcher.start()).append("<color:").append(matcher.group()).append(">");
            lastIndex = matcher.end();
        }
        result.append(text, lastIndex, text.length());
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            String key = tag.getKey();
            String value = tag.getValue();
            String upperKey = key.toUpperCase();
            result = new StringBuilder(result.toString().replace("&" + key, value).replace("&" + upperKey, value).replace("\u00a7" + key, value).replace("\u00a7" + upperKey, value));
        }
        return result.toString();
    }

    private String formatText(String text, Object ... rawReplaceList) {
        return this.legacyComponentSerializer.serialize(this.miniMessage.deserialize((Object)this.replaceParsedLegacyColors(this.replaceText(text, rawReplaceList))));
    }

    private String replaceParsedLegacyColors(String text) {
        if (text.indexOf(167) == -1) {
            return text;
        }
        Matcher matcher = this.PARSED_HEX_PATTERN.matcher(text);
        int lastMatchEnd = 0;
        StringBuilder result = new StringBuilder(text.length());
        while (matcher.find()) {
            result.append(text, lastMatchEnd, matcher.start());
            String hex = text.substring(matcher.start() + 3, matcher.end()).replace("\u00a7", "");
            result.append('#').append(hex);
            lastMatchEnd = matcher.end();
        }
        result.append(text, lastMatchEnd, text.length());
        int length = result.length();
        for (int i = 0; i < length; ++i) {
            if (result.charAt(i) != '\u00a7') continue;
            result.setCharAt(i, '&');
        }
        return result.toString();
    }
}

