/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerPlayerSitEvent;
import dev.geco.gsit.api.event.PlayerStopPlayerSitEvent;
import dev.geco.gsit.api.event.PrePlayerPlayerSitEvent;
import dev.geco.gsit.api.event.PrePlayerStopPlayerSitEvent;
import dev.geco.gsit.model.StopReason;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerSitService {
    public static final String PLAYERSIT_ENTITY_TAG = "GSit_PlayerSitEntity";
    private final GSitMain gSitMain;
    private final int sitEntityStackCount;
    private final HashMap<UUID, AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>>> bottomToTopStacks = new HashMap();
    private final HashMap<UUID, AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>>> topToBottomStacks = new HashMap();
    private final Set<Player> preventDismountStackPlayers = new HashSet<Player>();
    private final HashMap<String, Long> spawnTimes = new HashMap();
    private int playerSitCount = 0;
    private long playerSitTime = 0L;

    public PlayerSitService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.sitEntityStackCount = gSitMain.getVersionManager().isNewerOrVersion(1, 20, 2) ? 1 : 2;
    }

    public int getSitEntityStackCount() {
        return this.sitEntityStackCount;
    }

    public Set<Player> getPreventDismountStackPlayers() {
        return this.preventDismountStackPlayers;
    }

    public boolean isPlayerInPlayerSitStack(Player player) {
        return this.bottomToTopStacks.containsKey(player.getUniqueId()) || this.topToBottomStacks.containsKey(player.getUniqueId());
    }

    public void removeAllPlayerSitStacks() {
        for (UUID topPlayerUuid : new ArrayList<UUID>(this.topToBottomStacks.keySet())) {
            Player topPlayer = Bukkit.getPlayer((UUID)topPlayerUuid);
            if (topPlayer == null) continue;
            this.stopPlayerSit(topPlayer, StopReason.PLUGIN, false, true, true);
        }
        this.bottomToTopStacks.clear();
        this.topToBottomStacks.clear();
        this.preventDismountStackPlayers.clear();
    }

    public boolean sitOnPlayer(Player player, Player target) {
        if (!this.gSitMain.getEntityUtil().isPlayerSitLocationValid(target.getLocation())) {
            return false;
        }
        PrePlayerPlayerSitEvent prePlayerPlayerSitEvent = new PrePlayerPlayerSitEvent(player, target);
        Bukkit.getPluginManager().callEvent((Event)prePlayerPlayerSitEvent);
        if (prePlayerPlayerSitEvent.isCancelled()) {
            return false;
        }
        Set<UUID> playerSitEntityIds = this.gSitMain.getEntityUtil().createPlayerSitEntities(player, target);
        if (this.gSitMain.getConfigService().CUSTOM_MESSAGE) {
            this.gSitMain.getMessageService().sendActionBarMessage(player, "Messages.action-playersit-info", new Object[0]);
        }
        ++this.playerSitCount;
        this.bottomToTopStacks.put(target.getUniqueId(), new AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>>(player.getUniqueId(), playerSitEntityIds));
        this.topToBottomStacks.put(player.getUniqueId(), new AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>>(target.getUniqueId(), playerSitEntityIds));
        Bukkit.getPluginManager().callEvent((Event)new PlayerPlayerSitEvent(player, target));
        this.spawnTimes.put(target.getUniqueId().toString() + String.valueOf(player.getUniqueId()), System.nanoTime());
        return true;
    }

    public boolean stopPlayerSit(Player source, StopReason stopReason) {
        return this.stopPlayerSit(source, stopReason, true, true, true);
    }

    public boolean stopPlayerSit(Player source, StopReason stopReason, boolean removePassengers, boolean removeVehicle, boolean callPreEvent) {
        Long spawnTime;
        Object key;
        AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>> vehicles;
        AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>> passengers = removePassengers ? this.bottomToTopStacks.get(source.getUniqueId()) : null;
        AbstractMap.SimpleImmutableEntry<UUID, Set<UUID>> simpleImmutableEntry = vehicles = removeVehicle ? this.topToBottomStacks.get(source.getUniqueId()) : null;
        if (passengers == null && vehicles == null) {
            return true;
        }
        if (callPreEvent) {
            PrePlayerStopPlayerSitEvent prePlayerStopPlayerSitEvent = new PrePlayerStopPlayerSitEvent(source, stopReason);
            Bukkit.getPluginManager().callEvent((Event)prePlayerStopPlayerSitEvent);
            if (prePlayerStopPlayerSitEvent.isCancelled() && stopReason.isCancellable()) {
                return false;
            }
        }
        if (passengers != null) {
            source.eject();
            this.bottomToTopStacks.remove(source.getUniqueId());
            this.topToBottomStacks.remove(passengers.getKey());
            for (UUID passenger : passengers.getValue()) {
                Entity passengerEntity = Bukkit.getEntity((UUID)passenger);
                if (passengerEntity == null) continue;
                passengerEntity.remove();
            }
            key = source.getUniqueId().toString() + String.valueOf(passengers.getKey());
            spawnTime = this.spawnTimes.get(key);
            if (spawnTime != null) {
                this.playerSitTime += System.nanoTime() - spawnTime;
                this.spawnTimes.remove(key);
            }
        }
        if (vehicles != null) {
            source.leaveVehicle();
            this.topToBottomStacks.remove(source.getUniqueId());
            this.bottomToTopStacks.remove(vehicles.getKey());
            for (UUID vehicle : vehicles.getValue()) {
                Entity vehicleEntity = Bukkit.getEntity((UUID)vehicle);
                if (vehicleEntity == null) continue;
                vehicleEntity.remove();
            }
            key = vehicles.getKey().toString() + String.valueOf(source.getUniqueId());
            spawnTime = this.spawnTimes.get(key);
            if (spawnTime != null) {
                this.playerSitTime += System.nanoTime() - spawnTime;
                this.spawnTimes.remove(key);
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerStopPlayerSitEvent(source, stopReason));
        return true;
    }

    public int getPlayerSitCount() {
        return this.playerSitCount;
    }

    public int getPlayerSitTime() {
        return Math.toIntExact(this.playerSitTime / 1000000000L);
    }

    public void resetPlayerSitStats() {
        this.spawnTimes.clear();
        this.playerSitCount = 0;
        this.playerSitTime = 0L;
    }
}

