/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerCrawlEvent;
import dev.geco.gsit.api.event.PlayerStopCrawlEvent;
import dev.geco.gsit.api.event.PrePlayerCrawlEvent;
import dev.geco.gsit.api.event.PrePlayerStopCrawlEvent;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.StopReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CrawlService {
    private final GSitMain gSitMain;
    private final boolean available;
    private final HashMap<UUID, Crawl> crawls = new HashMap();
    private int crawlCount = 0;
    private long crawlTime = 0L;

    public CrawlService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.available = gSitMain.getVersionManager().isNewerOrVersion(1, 18);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public HashMap<UUID, Crawl> getAllCrawls() {
        return this.crawls;
    }

    public boolean isPlayerCrawling(Player player) {
        return this.crawls.containsKey(player.getUniqueId());
    }

    public Crawl getCrawlByPlayer(Player player) {
        return this.crawls.get(player.getUniqueId());
    }

    public void removeAllCrawls() {
        for (Crawl crawl : new ArrayList<Crawl>(this.crawls.values())) {
            this.stopCrawl(crawl, StopReason.PLUGIN);
        }
    }

    public Crawl startCrawl(Player player) {
        PrePlayerCrawlEvent prePlayerCrawlEvent = new PrePlayerCrawlEvent(player);
        Bukkit.getPluginManager().callEvent((Event)prePlayerCrawlEvent);
        if (prePlayerCrawlEvent.isCancelled()) {
            return null;
        }
        if (this.gSitMain.getConfigService().CUSTOM_MESSAGE) {
            this.gSitMain.getMessageService().sendActionBarMessage(player, "Messages.action-crawl-info", new Object[0]);
        }
        Crawl crawl = this.gSitMain.getEntityUtil().createCrawl(player);
        crawl.start();
        this.crawls.put(player.getUniqueId(), crawl);
        ++this.crawlCount;
        Bukkit.getPluginManager().callEvent((Event)new PlayerCrawlEvent(crawl));
        return crawl;
    }

    public boolean stopCrawl(Crawl crawl, StopReason stopReason) {
        PrePlayerStopCrawlEvent prePlayerStopCrawlEvent = new PrePlayerStopCrawlEvent(crawl, stopReason);
        Bukkit.getPluginManager().callEvent((Event)prePlayerStopCrawlEvent);
        if (prePlayerStopCrawlEvent.isCancelled() && stopReason.isCancellable()) {
            return false;
        }
        this.crawls.remove(crawl.getPlayer().getUniqueId());
        crawl.stop();
        Bukkit.getPluginManager().callEvent((Event)new PlayerStopCrawlEvent(crawl, stopReason));
        this.crawlTime += crawl.getLifetimeInNanoSeconds();
        return true;
    }

    public int getCrawlCount() {
        return this.crawlCount;
    }

    public int getCrawlTime() {
        return Math.toIntExact(this.crawlTime / 1000000000L);
    }

    public void resetCrawlStats() {
        this.crawlCount = 0;
        this.crawlTime = 0L;
    }
}

