/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_21_11.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_21_11.entity.PlayerSitEntity;
import dev.geco.gsit.mcv.v1_21_11.entity.SeatEntity;
import dev.geco.gsit.mcv.v1_21_11.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityUtil
implements dev.geco.gsit.util.EntityUtil {
    private final GSitMain gSitMain;
    private Field entityManager = null;

    public EntityUtil(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        ArrayList<Field> entityManagerFieldList = new ArrayList<Field>();
        for (Field field : WorldServer.class.getDeclaredFields()) {
            if (!field.getType().equals(PersistentEntitySectionManager.class)) continue;
            entityManagerFieldList.add(field);
        }
        if (entityManagerFieldList.isEmpty()) {
            return;
        }
        this.entityManager = (Field)entityManagerFieldList.getFirst();
        if (this.entityManager != null) {
            this.entityManager.setAccessible(true);
        }
    }

    @Override
    public void setEntityLocation(Entity entity, Location location) {
        if (entity instanceof Player) {
            PlayerConnection serverGamePacketListener = ((CraftPlayer)entity).getHandle().g;
            serverGamePacketListener.internalTeleport(location);
            serverGamePacketListener.m();
        } else {
            ((CraftEntity)entity).getHandle().b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
    }

    @Override
    public boolean isSitLocationValid(Location location) {
        return true;
    }

    @Override
    public boolean isPlayerSitLocationValid(Location location) {
        return true;
    }

    @Override
    public Entity createSeatEntity(Location location, Entity entity, boolean canRotate) {
        if (entity == null || !entity.isValid()) {
            return null;
        }
        net.minecraft.world.entity.Entity rider = ((CraftEntity)entity).getHandle();
        SeatEntity seatEntity = new SeatEntity(location);
        boolean riding = true;
        if (!this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
            riding = rider.a((net.minecraft.world.entity.Entity)seatEntity, true, true);
        }
        if (!this.spawnEntity((net.minecraft.world.entity.Entity)seatEntity)) {
            return null;
        }
        if (this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
            riding = rider.a((net.minecraft.world.entity.Entity)seatEntity, true, true);
        }
        if (!riding || !seatEntity.aS.contains((Object)rider)) {
            seatEntity.aC();
            return null;
        }
        if (canRotate) {
            seatEntity.startRotate();
        }
        return seatEntity.getBukkitEntity();
    }

    @Override
    public Set<UUID> createPlayerSitEntities(Player player, Player target) {
        if (player == null || !player.isValid()) {
            return Collections.emptySet();
        }
        Object topEntity = ((CraftEntity)target).getHandle();
        int maxEntities = this.gSitMain.getPlayerSitService().getSitEntityStackCount();
        if (maxEntities <= 0) {
            ((CraftEntity)player).getHandle().a(topEntity, true, true);
            return Collections.emptySet();
        }
        HashSet<UUID> playerSitEntityIds = new HashSet<UUID>();
        for (int entityCount = 1; entityCount <= maxEntities; ++entityCount) {
            PlayerSitEntity playerSitEntity = new PlayerSitEntity(target.getLocation());
            playerSitEntity.a((net.minecraft.world.entity.Entity)topEntity, true, true);
            if (entityCount == maxEntities) {
                ((CraftEntity)player).getHandle().a((net.minecraft.world.entity.Entity)playerSitEntity, true, true);
            }
            if (!this.spawnEntity((net.minecraft.world.entity.Entity)playerSitEntity)) {
                ((CraftEntity)player).getHandle().a(topEntity, true, true);
                return playerSitEntityIds;
            }
            playerSitEntityIds.add(playerSitEntity.cY());
            topEntity = playerSitEntity;
        }
        return playerSitEntityIds;
    }

    private boolean spawnEntity(net.minecraft.world.entity.Entity entity) {
        if (this.entityManager != null) {
            try {
                PersistentEntitySectionManager entityLookup = (PersistentEntitySectionManager)this.entityManager.get(entity.ao().getWorld().getHandle());
                return entityLookup.a((EntityAccess)entity);
            }
            catch (Throwable e) {
                this.gSitMain.getLogger().log(Level.SEVERE, "Could not spawn entity", e);
                return false;
            }
        }
        try {
            LevelEntityGetter levelEntityGetter = entity.ao().M();
            return (Boolean)levelEntityGetter.getClass().getMethod("addNewEntity", net.minecraft.world.entity.Entity.class).invoke((Object)levelEntityGetter, entity);
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not spawn entity", e);
            return false;
        }
    }

    @Override
    public Pose createPose(Seat seat, PoseType poseType) {
        return new dev.geco.gsit.mcv.v1_21_11.model.Pose(seat, poseType);
    }

    @Override
    public dev.geco.gsit.model.Crawl createCrawl(Player player) {
        return new Crawl(player);
    }
}

