/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_19_4.event;

import dev.geco.gsit.GSitMain;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class EntityEventHandler
implements Listener {
    private final GSitMain gSitMain;

    public EntityEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void entityMountEventLow(EntityMountEvent event) {
        if (this.gSitMain.getWorldGuardLink() == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getMount().getScoreboardTags().contains("GSit_sit")) {
            return;
        }
        player.setMetadata("NPC", (MetadataValue)new FixedMetadataValue((Plugin)this.gSitMain, null));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void entityMountEventHigh(EntityMountEvent event) {
        if (this.gSitMain.getWorldGuardLink() == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getMount().getScoreboardTags().contains("GSit_sit")) {
            return;
        }
        if (!player.hasMetadata("NPC")) {
            return;
        }
        player.removeMetadata("NPC", (Plugin)this.gSitMain);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void entityDismountEvent(EntityDismountEvent event) {
        this.gSitMain.getEntityEventHandler().handleEntityDismountEvent((Cancellable)event, event.getEntity(), event.getDismounted());
    }
}

