/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.link;

import dev.geco.gsit.GSitMain;
import java.util.Arrays;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPILink
extends PlaceholderExpansion {
    private final GSitMain gSitMain;

    public PlaceholderAPILink(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean canRegister() {
        return this.gSitMain.isEnabled();
    }

    @NotNull
    public String getName() {
        return this.gSitMain.getDescription().getName();
    }

    @NotNull
    public String getIdentifier() {
        return "GSit".toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return this.gSitMain.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.gSitMain.getDescription().getVersion();
    }

    @NotNull
    public List<String> getPlaceholders() {
        return Arrays.asList("crawling", "playertoggle", "posing", "sitting", "toggle");
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String placeholder) {
        if (offlinePlayer == null) {
            return null;
        }
        if (placeholder.equalsIgnoreCase("crawling")) {
            return offlinePlayer.isOnline() ? "" + this.gSitMain.getCrawlService().isPlayerCrawling(offlinePlayer.getPlayer()) : "false";
        }
        if (placeholder.equalsIgnoreCase("playertoggle")) {
            return "" + this.gSitMain.getToggleService().canPlayerUsePlayerSit(offlinePlayer.getUniqueId());
        }
        if (placeholder.equalsIgnoreCase("posing")) {
            return offlinePlayer.isOnline() ? "" + this.gSitMain.getPoseService().isPlayerPosing(offlinePlayer.getPlayer()) : "false";
        }
        if (placeholder.equalsIgnoreCase("sitting")) {
            return offlinePlayer.isOnline() ? "" + this.gSitMain.getSitService().isEntitySitting((LivingEntity)offlinePlayer.getPlayer()) : "false";
        }
        if (placeholder.equalsIgnoreCase("toggle")) {
            return "" + this.gSitMain.getToggleService().canEntityUseSit(offlinePlayer.getUniqueId());
        }
        return null;
    }
}

