/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit;

import dev.geco.gsit.api.event.GSitLoadedEvent;
import dev.geco.gsit.api.event.GSitReloadEvent;
import dev.geco.gsit.cmd.GBellyflopCommand;
import dev.geco.gsit.cmd.GCrawlCommand;
import dev.geco.gsit.cmd.GLayBackCommand;
import dev.geco.gsit.cmd.GLayCommand;
import dev.geco.gsit.cmd.GSitCommand;
import dev.geco.gsit.cmd.GSitReloadCommand;
import dev.geco.gsit.cmd.GSpinCommand;
import dev.geco.gsit.cmd.tab.EmptyTabComplete;
import dev.geco.gsit.cmd.tab.GCrawlTabComplete;
import dev.geco.gsit.cmd.tab.GSitTabComplete;
import dev.geco.gsit.event.BlockEventHandler;
import dev.geco.gsit.event.EntityEventHandler;
import dev.geco.gsit.event.PlayerEventHandler;
import dev.geco.gsit.event.PlayerSitEventHandler;
import dev.geco.gsit.event.SitEventHandler;
import dev.geco.gsit.event.feature.SpinConfusionEventHandler;
import dev.geco.gsit.link.GriefPreventionLink;
import dev.geco.gsit.link.PlaceholderAPILink;
import dev.geco.gsit.link.PlotSquaredLink;
import dev.geco.gsit.link.WorldGuardLink;
import dev.geco.gsit.metric.BStatsMetric;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.service.ConfigService;
import dev.geco.gsit.service.CrawlService;
import dev.geco.gsit.service.DataService;
import dev.geco.gsit.service.MessageService;
import dev.geco.gsit.service.PermissionService;
import dev.geco.gsit.service.PlayerSitService;
import dev.geco.gsit.service.PoseService;
import dev.geco.gsit.service.SitService;
import dev.geco.gsit.service.TaskService;
import dev.geco.gsit.service.ToggleService;
import dev.geco.gsit.service.UpdateService;
import dev.geco.gsit.service.VersionService;
import dev.geco.gsit.service.message.PaperMessageService;
import dev.geco.gsit.service.message.SpigotMessageService;
import dev.geco.gsit.util.EntityUtil;
import dev.geco.gsit.util.EnvironmentUtil;
import dev.geco.gsit.util.LegacyEntityUtil;
import dev.geco.gsit.util.PassengerUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GSitMain
extends JavaPlugin {
    public static final String NAME = "GSit";
    public static final String RESOURCE_ID = "62325";
    private final int BSTATS_RESOURCE_ID = 4914;
    private static GSitMain gSitMain;
    private VersionService versionService;
    private ConfigService configService;
    private MessageService messageService;
    private UpdateService updateService;
    private PermissionService permissionService;
    private TaskService taskService;
    private DataService dataService;
    private SitService sitService;
    private PlayerSitService playerSitService;
    private PoseService poseService;
    private CrawlService crawlService;
    private ToggleService toggleService;
    private EntityEventHandler entityEventHandler;
    private PassengerUtil passengerUtil;
    private EnvironmentUtil environmentUtil;
    private EntityUtil entityUtil;
    private GriefPreventionLink griefPreventionLink;
    private PlaceholderAPILink placeholderAPILink;
    private PlotSquaredLink plotSquaredLink;
    private WorldGuardLink worldGuardLink;
    private BStatsMetric bStatsMetric;
    private boolean supportsTaskFeature = false;
    private boolean isPaperServer = false;
    private boolean isFoliaServer = false;

    public static GSitMain getInstance() {
        return gSitMain;
    }

    public VersionService getVersionManager() {
        return this.versionService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public SitService getSitService() {
        return this.sitService;
    }

    public PlayerSitService getPlayerSitService() {
        return this.playerSitService;
    }

    public PoseService getPoseService() {
        return this.poseService;
    }

    public CrawlService getCrawlService() {
        return this.crawlService;
    }

    public ToggleService getToggleService() {
        return this.toggleService;
    }

    public EntityEventHandler getEntityEventHandler() {
        return this.entityEventHandler;
    }

    public PassengerUtil getPassengerUtil() {
        return this.passengerUtil;
    }

    public EnvironmentUtil getEnvironmentUtil() {
        return this.environmentUtil;
    }

    public EntityUtil getEntityUtil() {
        return this.entityUtil;
    }

    public GriefPreventionLink getGriefPreventionLink() {
        return this.griefPreventionLink;
    }

    public PlaceholderAPILink getPlaceholderAPILink() {
        return this.placeholderAPILink;
    }

    public PlotSquaredLink getPlotSquaredLink() {
        return this.plotSquaredLink;
    }

    public WorldGuardLink getWorldGuardLink() {
        return this.worldGuardLink;
    }

    public boolean supportsTaskFeature() {
        return this.supportsTaskFeature;
    }

    public boolean isPaperServer() {
        return this.isPaperServer;
    }

    public boolean isFoliaServer() {
        return this.isFoliaServer;
    }

    public void onLoad() {
        gSitMain = this;
        this.versionService = new VersionService(this);
        this.configService = new ConfigService(this);
        this.updateService = new UpdateService(this);
        this.permissionService = new PermissionService();
        this.taskService = new TaskService(this);
        this.dataService = new DataService(this);
        this.sitService = new SitService(this);
        this.playerSitService = new PlayerSitService(this);
        this.poseService = new PoseService(this);
        this.crawlService = new CrawlService(this);
        this.toggleService = new ToggleService(this);
        this.entityEventHandler = new EntityEventHandler(this);
        this.passengerUtil = new PassengerUtil();
        this.environmentUtil = new EnvironmentUtil(this);
        this.loadFeatures();
        this.messageService = this.isPaperServer && this.versionService.isNewerOrVersion(1, 18, 2) ? new PaperMessageService(this) : new SpigotMessageService(this);
    }

    public void onEnable() {
        if (!this.versionCheck()) {
            return;
        }
        this.entityUtil = this.versionService.isNewerOrVersion(1, 18) ? (EntityUtil)this.versionService.getPackageObjectInstance("util.EntityUtil", new Object[]{this}) : new LegacyEntityUtil(this);
        this.loadPluginDependencies();
        this.loadSettings((CommandSender)Bukkit.getConsoleSender());
        this.setupCommands();
        this.setupEvents();
        this.setupBStatsMetric();
        Bukkit.getPluginManager().callEvent((Event)new GSitLoadedEvent(this));
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-enabled", new Object[0]);
        this.printPluginLinks((CommandSender)Bukkit.getConsoleSender());
        this.updateService.checkForUpdates();
    }

    public void onDisable() {
        this.unload();
        if (this.bStatsMetric != null) {
            this.bStatsMetric.shutdown();
        }
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-disabled", new Object[0]);
    }

    private void loadSettings(CommandSender sender) {
        if (!this.connectDatabase(sender)) {
            return;
        }
        this.toggleService.createDataTables();
    }

    public void reload(CommandSender sender) {
        GSitReloadEvent reloadEvent = new GSitReloadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)reloadEvent);
        if (reloadEvent.isCancelled()) {
            return;
        }
        this.unload();
        this.configService.reload();
        this.messageService.loadMessages();
        this.loadPluginDependencies();
        this.loadSettings(sender);
        this.printPluginLinks(sender);
        this.updateService.checkForUpdates();
        Bukkit.getPluginManager().callEvent((Event)new GSitLoadedEvent(this));
    }

    private void unload() {
        this.dataService.close();
        this.sitService.removeAllSeats();
        this.playerSitService.removeAllPlayerSitStacks();
        this.poseService.removeAllPoses();
        this.crawlService.removeAllCrawls();
        if (this.placeholderAPILink != null) {
            this.placeholderAPILink.unregister();
        }
        if (this.worldGuardLink != null) {
            this.worldGuardLink.unregisterFlagHandlers();
        }
    }

    private void setupCommands() {
        this.getCommand("gsit").setExecutor((CommandExecutor)new GSitCommand(this));
        this.getCommand("gsit").setTabCompleter((TabCompleter)new GSitTabComplete(this));
        this.getCommand("glay").setExecutor((CommandExecutor)new GLayCommand(this));
        this.getCommand("glay").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("glay").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("glayback").setExecutor((CommandExecutor)new GLayBackCommand(this));
        this.getCommand("glayback").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("glayback").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gbellyflop").setExecutor((CommandExecutor)new GBellyflopCommand(this));
        this.getCommand("gbellyflop").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gbellyflop").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gspin").setExecutor((CommandExecutor)new GSpinCommand(this));
        this.getCommand("gspin").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gspin").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gcrawl").setExecutor((CommandExecutor)new GCrawlCommand(this));
        this.getCommand("gcrawl").setTabCompleter((TabCompleter)new GCrawlTabComplete(this));
        this.getCommand("gsitreload").setExecutor((CommandExecutor)new GSitReloadCommand(this));
        this.getCommand("gsitreload").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gsitreload").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
    }

    private void setupEvents() {
        Listener mcvEntityEventHandler;
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSitEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SitEventHandler(this), (Plugin)this);
        Listener listener = mcvEntityEventHandler = this.versionService.isNewerOrVersion(1, 18) ? (Listener)this.versionService.getPackageObjectInstance("event.EntityEventHandler", new Object[]{this}) : null;
        if (mcvEntityEventHandler == null) {
            mcvEntityEventHandler = (Listener)this.versionService.getLegacyPackageObjectInstance("event.EntityEventHandler", new Object[]{this});
        }
        if (mcvEntityEventHandler != null) {
            this.getServer().getPluginManager().registerEvents(mcvEntityEventHandler, (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SpinConfusionEventHandler(this), (Plugin)this);
    }

    private boolean versionCheck() {
        if (!this.versionService.isNewerOrVersion(1, 16) || this.versionService.isNewerOrVersion(1, 18) && !this.versionService.isAvailable()) {
            this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-version", "%Version%", Bukkit.getServer().getVersion());
            this.updateService.checkForUpdates();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    private boolean connectDatabase(CommandSender sender) {
        boolean connected = this.dataService.connect();
        if (connected) {
            return true;
        }
        this.messageService.sendMessage(sender, "Plugin.plugin-data", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private void loadFeatures() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            this.supportsTaskFeature = true;
        }
        catch (ClassNotFoundException e) {
            this.supportsTaskFeature = false;
        }
        try {
            Class.forName("io.papermc.paper.event.entity.EntityMoveEvent");
            this.isPaperServer = true;
        }
        catch (ClassNotFoundException e) {
            this.isPaperServer = false;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
            this.isFoliaServer = true;
        }
        catch (ClassNotFoundException e) {
            this.isFoliaServer = false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardLink = new WorldGuardLink();
            this.worldGuardLink.registerFlags();
        }
    }

    private void loadPluginDependencies() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("GriefPrevention");
        this.griefPreventionLink = plugin != null && plugin.isEnabled() && this.configService.TRUSTED_REGION_ONLY ? new GriefPreventionLink(this) : null;
        plugin = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        if (plugin != null && plugin.isEnabled()) {
            this.placeholderAPILink = new PlaceholderAPILink(this);
            this.placeholderAPILink.register();
        } else {
            this.placeholderAPILink = null;
        }
        plugin = Bukkit.getPluginManager().getPlugin("PlotSquared");
        if (plugin != null && plugin.isEnabled() && this.configService.TRUSTED_REGION_ONLY) {
            this.plotSquaredLink = new PlotSquaredLink(this);
            if (!this.plotSquaredLink.isPlotSquaredVersionSupported()) {
                this.plotSquaredLink = null;
            }
        } else {
            this.plotSquaredLink = null;
        }
        if ((plugin = Bukkit.getPluginManager().getPlugin("WorldGuard")) != null && plugin.isEnabled()) {
            if (this.worldGuardLink == null) {
                this.worldGuardLink = new WorldGuardLink();
                this.worldGuardLink.registerFlags();
            }
            this.worldGuardLink.registerFlagHandlers();
        } else {
            this.worldGuardLink = null;
        }
    }

    private void printPluginLinks(CommandSender sender) {
        if (this.griefPreventionLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("GriefPrevention").getName());
        }
        if (this.placeholderAPILink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("PlaceholderAPI").getName());
        }
        if (this.plotSquaredLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("PlotSquared").getName());
        }
        if (this.worldGuardLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("WorldGuard").getName());
        }
    }

    private void setupBStatsMetric() {
        this.bStatsMetric = new BStatsMetric((Plugin)this, 4914);
        this.bStatsMetric.addCustomChart(new BStatsMetric.SimplePie("plugin_language", () -> this.configService.L_LANG));
        this.bStatsMetric.addCustomChart(new BStatsMetric.AdvancedPie("minecraft_version_player_amount", () -> Map.of(this.versionService.getServerVersion(), Bukkit.getOnlinePlayers().size())));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("sit_count", () -> this.sitService.getSitCount()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("sit_time", () -> this.sitService.getSitTime()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("player_sit_count", () -> this.playerSitService.getPlayerSitCount()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("player_sit_time", () -> this.playerSitService.getPlayerSitTime()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("pose_count", () -> this.poseService.getPoseCount().values().stream().mapToInt(Integer::intValue).sum()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("pose_time", () -> this.poseService.getPoseTime().values().stream().mapToInt(Integer::intValue).sum()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("crawl_count", () -> this.crawlService.getCrawlCount()));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("crawl_time", () -> this.crawlService.getCrawlTime()));
        for (PoseType poseType : PoseType.values()) {
            this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart(poseType.getName() + "_count", () -> this.poseService.getPoseCount().getOrDefault((Object)poseType, 0)));
            this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart(poseType.getName() + "_time", () -> Math.toIntExact(this.poseService.getPoseTime().getOrDefault((Object)poseType, 0).intValue())));
        }
        this.bStatsMetric.setCollectCallback(() -> {
            this.sitService.resetSitStats();
            this.playerSitService.resetPlayerSitStats();
            this.poseService.resetPoseStats();
            this.crawlService.resetCrawlStats();
        });
    }
}

