/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service.message;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.service.MessageService;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpigotMessageService
extends MessageService {
    protected boolean allowBungeeMessages = true;

    public SpigotMessageService(GSitMain gSitMain) {
        super(gSitMain);
        try {
            Class.forName("net.md_5.bungee.api.ChatMessageType");
        }
        catch (Throwable e) {
            this.allowBungeeMessages = false;
        }
    }

    @Override
    public String toFormattedMessage(String text, Object ... rawReplaceList) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.replaceHexColorsDirectly(this.replaceText(text, rawReplaceList).replace("<lang:key.sneak>", "Sneak")));
    }

    @Override
    public void sendMessage(@NotNull CommandSender target, String message, Object ... replaceList) {
        String translatedMessage = this.getTranslatedMessage(message, this.getLanguageForTarget(target), replaceList);
        if (translatedMessage.isEmpty()) {
            return;
        }
        target.sendMessage(translatedMessage);
    }

    @Override
    public void sendActionBarMessage(@NotNull Player target, String message, Object ... replaceList) {
        if (!this.allowBungeeMessages) {
            return;
        }
        String translatedMessage = this.getTranslatedMessage(message, this.getLanguageForTarget((CommandSender)target), replaceList);
        if (translatedMessage.isEmpty()) {
            return;
        }
        target.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)translatedMessage));
    }
}

