/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class VersionService {
    private final String LATEST_VERSION = "v1_21_11";
    private final HashMap<String, String> VERSION_MAPPING = new HashMap();
    private final GSitMain gSitMain;
    private final String serverVersion;
    private String packagePath;
    private boolean available;

    public VersionService(GSitMain gSitMain) {
        this.VERSION_MAPPING.put("v1_18_1", "v1_18");
        this.VERSION_MAPPING.put("v1_19_2", "v1_19_1");
        this.VERSION_MAPPING.put("v1_20_1", "v1_20");
        this.VERSION_MAPPING.put("v1_20_4", "v1_20_3");
        this.VERSION_MAPPING.put("v1_20_6", "v1_20_5");
        this.VERSION_MAPPING.put("v1_21_1", "v1_21");
        this.VERSION_MAPPING.put("v1_21_3", "v1_21_2");
        this.VERSION_MAPPING.put("v1_21_7", "v1_21_6");
        this.VERSION_MAPPING.put("v1_21_8", "v1_21_6");
        this.VERSION_MAPPING.put("v1_21_10", "v1_21_9");
        this.gSitMain = gSitMain;
        this.serverVersion = this.getMinecraftVersion();
        if (!this.isNewerOrVersion(new int[]{1, 18})) {
            return;
        }
        this.packagePath = ((Object)((Object)gSitMain)).getClass().getPackage().getName() + ".mcv." + this.getPackageVersion();
        this.available = this.hasPackageClass("entity.SeatEntity");
        if (this.available) {
            return;
        }
        this.packagePath = ((Object)((Object)gSitMain)).getClass().getPackage().getName() + ".mcv.v1_21_11";
        this.available = this.hasPackageClass("entity.SeatEntity");
    }

    private String getMinecraftVersion() {
        String rawServerVersion = Bukkit.getServer().getVersion();
        int mcIndexStart = rawServerVersion.indexOf("MC:");
        if (mcIndexStart != -1) {
            int mcDashIndex;
            int mcIndexEnd = rawServerVersion.indexOf(41, mcIndexStart += 3);
            if (mcIndexEnd != -1) {
                rawServerVersion = rawServerVersion.substring(mcIndexStart, mcIndexEnd);
            }
            if ((mcDashIndex = rawServerVersion.indexOf(45, mcIndexStart)) != -1) {
                rawServerVersion = rawServerVersion.substring(mcIndexStart, mcDashIndex);
            }
        }
        return rawServerVersion.trim();
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isNewerOrVersion(int[] version) {
        String[] parts = this.serverVersion.split("\\.");
        int max = Math.max(parts.length, version.length);
        for (int i = 0; i < max; ++i) {
            int tv;
            int sv = i < parts.length ? Integer.parseInt(parts[i]) : 0;
            int n = tv = i < version.length ? version[i] : 0;
            if (sv > tv) {
                return true;
            }
            if (sv >= tv) continue;
            return false;
        }
        return true;
    }

    public Object getLegacyPackageObjectInstance(String className, Object ... parameters) {
        try {
            Class<?> mcvPackageClass = Class.forName(((Object)((Object)this.gSitMain)).getClass().getPackage().getName() + ".mcv.v1_17_1." + className);
            if (parameters.length == 0) {
                return mcvPackageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new);
            return mcvPackageClass.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not get legacy package object with class name '" + className + "'!", e);
            return null;
        }
    }

    public Object getPackageObjectInstance(String className, Object ... parameters) {
        try {
            Class<?> mcvPackageClass = Class.forName(this.packagePath + "." + className);
            if (parameters.length == 0) {
                return mcvPackageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new);
            return mcvPackageClass.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not get package object with class name '" + className + "'!", e);
            return null;
        }
    }

    public boolean hasPackageClass(String className) {
        try {
            Class.forName(this.packagePath + "." + className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String getPackageVersion() {
        String packageVersion = "v" + this.serverVersion.replace(".", "_");
        return this.VERSION_MAPPING.getOrDefault(packageVersion, packageVersion);
    }
}

