/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.EntitySitEvent;
import dev.geco.gsit.api.event.EntityStopSitEvent;
import dev.geco.gsit.api.event.PreEntitySitEvent;
import dev.geco.gsit.api.event.PreEntityStopSitEvent;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.permissions.Permissible;

public class SitService {
    public static final double STAIR_XZ_OFFSET = 0.123;
    public static final double STAIR_Y_OFFSET = 0.5;
    public static final String SIT_TAG = "GSit_sit";
    private final GSitMain gSitMain;
    private final double baseOffset;
    private final HashMap<UUID, Seat> seats = new HashMap();
    private final HashMap<Block, Set<Seat>> blockSeats = new HashMap();
    private int sitCount = 0;
    private long sitTime = 0L;

    public SitService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.baseOffset = gSitMain.getVersionManager().isNewerOrVersion(new int[]{1, 20, 2}) ? -0.05 : 0.2;
    }

    public double getBaseOffset() {
        return this.baseOffset;
    }

    public HashMap<UUID, Seat> getAllSeats() {
        return this.seats;
    }

    public boolean isEntitySitting(LivingEntity entity) {
        return this.seats.containsKey(entity.getUniqueId());
    }

    public Seat getSeatByEntity(LivingEntity entity) {
        return this.seats.get(entity.getUniqueId());
    }

    public void removeAllSeats() {
        for (Seat seat : new ArrayList<Seat>(this.seats.values())) {
            this.removeSeat(seat, StopReason.PLUGIN);
        }
    }

    public boolean isBlockWithSeat(Block block) {
        return this.blockSeats.containsKey(block);
    }

    public Set<Seat> getSeatsByBlock(Block block) {
        return this.blockSeats.getOrDefault(block, Collections.emptySet());
    }

    public boolean kickSeatEntitiesFromBlock(Block block, LivingEntity entity) {
        if (!this.isBlockWithSeat(block)) {
            return true;
        }
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)entity, "Kick.Sit", "Kick.*")) {
            return false;
        }
        for (Seat seat : this.getSeatsByBlock(block)) {
            if (this.removeSeat(seat, StopReason.KICKED)) continue;
            return false;
        }
        return true;
    }

    public Seat createSeat(Block block, LivingEntity entity) {
        return this.createSeat(block, entity, true, 0.0, 0.0, 0.0, entity.getLocation().getYaw(), this.gSitMain.getConfigService().CENTER_BLOCK);
    }

    public Seat createSeat(Block block, LivingEntity entity, boolean canRotate, double xOffset, double yOffset, double zOffset, float seatRotation, boolean sitInBlockCenter) {
        Location returnLocation = entity.getLocation();
        Location seatLocation = this.getSeatLocation(block, returnLocation, xOffset, yOffset, zOffset, sitInBlockCenter);
        if (!this.gSitMain.getEntityUtil().isSitLocationValid(seatLocation)) {
            return null;
        }
        PreEntitySitEvent preEntitySitEvent = new PreEntitySitEvent(entity, block);
        Bukkit.getPluginManager().callEvent((Event)preEntitySitEvent);
        if (preEntitySitEvent.isCancelled()) {
            return null;
        }
        seatLocation.setYaw(seatRotation);
        Entity seatEntity = this.gSitMain.getEntityUtil().createSeatEntity(seatLocation, (Entity)entity, canRotate);
        if (seatEntity == null) {
            return null;
        }
        if (this.gSitMain.getConfigService().CUSTOM_MESSAGE && entity instanceof Player) {
            this.gSitMain.getMessageService().sendActionBarMessage((Player)entity, "Messages.action-sit-info", new Object[0]);
            if (this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
                this.gSitMain.getTaskService().runDelayed(() -> this.gSitMain.getMessageService().sendActionBarMessage((Player)entity, "Messages.action-sit-info", new Object[0]), (Entity)entity, 2L);
            }
        }
        Seat seat = new Seat(block, seatLocation, entity, seatEntity, returnLocation);
        this.seats.put(entity.getUniqueId(), seat);
        this.blockSeats.computeIfAbsent(block, b -> new HashSet()).add(seat);
        ++this.sitCount;
        Bukkit.getPluginManager().callEvent((Event)new EntitySitEvent(seat));
        return seat;
    }

    public Location getSeatLocation(Block block, Location location, double xOffset, double yOffset, double zOffset, boolean sitInBlockCenter) {
        double additionalOffset;
        double d = additionalOffset = sitInBlockCenter ? block.getBoundingBox().getMinY() + block.getBoundingBox().getHeight() : 0.0;
        additionalOffset = (sitInBlockCenter ? (additionalOffset == 0.0 ? 1.0 : additionalOffset - (double)block.getY()) : additionalOffset) + this.gSitMain.getConfigService().S_SITMATERIALS.getOrDefault(block.getType(), 0.0);
        if (sitInBlockCenter) {
            return block.getLocation().add(0.5 + xOffset, yOffset - this.baseOffset + additionalOffset, 0.5 + zOffset);
        }
        return location.add(xOffset, yOffset - this.baseOffset + this.gSitMain.getConfigService().S_SITMATERIALS.getOrDefault(block.getType(), 0.0), zOffset);
    }

    public void moveSeat(Seat seat, BlockFace blockDirection) {
        Set<Seat> blockSeatList;
        LivingEntity livingEntity = seat.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerMoveEvent playerMoveEvent = new PlayerMoveEvent(player, player.getLocation(), player.getLocation().add((double)blockDirection.getModX(), (double)blockDirection.getModY(), (double)blockDirection.getModZ()));
            Bukkit.getPluginManager().callEvent((Event)playerMoveEvent);
            if (playerMoveEvent.isCancelled()) {
                return;
            }
        }
        if ((blockSeatList = this.blockSeats.get(seat.getBlock())) != null) {
            blockSeatList.remove(seat);
        }
        seat.setBlock(seat.getBlock().getRelative(blockDirection));
        this.blockSeats.computeIfAbsent(seat.getBlock(), b -> new HashSet()).add(seat);
        seat.setLocation(seat.getLocation().add((double)blockDirection.getModX(), (double)blockDirection.getModY(), (double)blockDirection.getModZ()));
        this.gSitMain.getEntityUtil().setEntityLocation(seat.getSeatEntity(), seat.getLocation());
    }

    public boolean removeSeat(Seat seat, StopReason stopReason) {
        return this.removeSeat(seat, stopReason, true);
    }

    public boolean removeSeat(Seat seat, StopReason stopReason, boolean useSafeDismount) {
        Set<Seat> blockSeatList;
        PreEntityStopSitEvent preEntityStopSitEvent = new PreEntityStopSitEvent(seat, stopReason);
        Bukkit.getPluginManager().callEvent((Event)preEntityStopSitEvent);
        if (preEntityStopSitEvent.isCancelled() && stopReason.isCancellable()) {
            return false;
        }
        LivingEntity entity = seat.getEntity();
        this.seats.remove(entity.getUniqueId());
        if (useSafeDismount) {
            this.handleSafeSeatDismount(seat);
        }
        if ((blockSeatList = this.blockSeats.remove(seat.getBlock())) != null) {
            blockSeatList.remove(seat);
            if (blockSeatList.isEmpty()) {
                this.blockSeats.remove(seat.getBlock());
            }
        }
        seat.getSeatEntity().remove();
        Bukkit.getPluginManager().callEvent((Event)new EntityStopSitEvent(seat, stopReason));
        this.sitTime += seat.getLifetimeInNanoSeconds();
        return true;
    }

    public void handleSafeSeatDismount(Seat seat) {
        block4: {
            LivingEntity entity = seat.getEntity();
            try {
                Material blockType = seat.getBlock().getType();
                Location upLocation = seat.getLocation().add(0.0, this.baseOffset + (Tag.STAIRS.isTagged((Keyed)blockType) ? 0.5 : 0.0) - this.gSitMain.getConfigService().S_SITMATERIALS.getOrDefault(blockType, 0.0), 0.0);
                Location returnLocation = this.gSitMain.getConfigService().GET_UP_RETURN ? seat.getReturnLocation() : upLocation;
                Location entityLocation = entity.getLocation();
                returnLocation.setYaw(entityLocation.getYaw());
                returnLocation.setPitch(entityLocation.getPitch());
                if (entity.isValid()) {
                    this.gSitMain.getEntityUtil().setEntityLocation((Entity)entity, returnLocation);
                }
                if (seat.getSeatEntity().isValid() && !this.gSitMain.getVersionManager().isNewerOrVersion(new int[]{1, 17})) {
                    this.gSitMain.getEntityUtil().setEntityLocation(seat.getSeatEntity(), returnLocation);
                }
            }
            catch (Throwable e) {
                if (this.gSitMain.isFoliaServer()) break block4;
                this.gSitMain.getLogger().log(Level.SEVERE, "Could not safely dismount the entity!", e);
            }
        }
    }

    public Seat createStairSeatForEntity(Block block, LivingEntity entity) {
        Stairs blockData = (Stairs)block.getBlockData();
        if (blockData.getHalf() != Bisected.Half.BOTTOM) {
            return this.createSeat(block, entity);
        }
        BlockFace blockFace = blockData.getFacing().getOppositeFace();
        if (blockData.getShape() == Stairs.Shape.STRAIGHT) {
            return switch (blockFace) {
                case BlockFace.EAST -> this.createSeat(block, entity, false, 0.123, -0.5, 0.0, -90.0f, true);
                case BlockFace.SOUTH -> this.createSeat(block, entity, false, 0.0, -0.5, 0.123, 0.0f, true);
                case BlockFace.WEST -> this.createSeat(block, entity, false, -0.123, -0.5, 0.0, 90.0f, true);
                case BlockFace.NORTH -> this.createSeat(block, entity, false, 0.0, -0.5, -0.123, 180.0f, true);
                default -> null;
            };
        }
        Stairs.Shape stairShape = blockData.getShape();
        if (blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.INNER_RIGHT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.INNER_LEFT) {
            return this.createSeat(block, entity, false, 0.123, -0.5, -0.123, -135.0f, true);
        }
        if (blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.INNER_LEFT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.INNER_RIGHT) {
            return this.createSeat(block, entity, false, -0.123, -0.5, -0.123, 135.0f, true);
        }
        if (blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.INNER_RIGHT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.INNER_LEFT) {
            return this.createSeat(block, entity, false, -0.123, -0.5, 0.123, 45.0f, true);
        }
        if (blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.INNER_LEFT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.INNER_RIGHT) {
            return this.createSeat(block, entity, false, 0.123, -0.5, 0.123, -45.0f, true);
        }
        return null;
    }

    public int getSitCount() {
        return this.sitCount;
    }

    public int getSitTime() {
        return Math.toIntExact(this.sitTime / 1000000000L);
    }

    public void resetSitStats() {
        this.sitCount = 0;
        this.sitTime = 0L;
    }
}

