/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConfigurationOptions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class MessageService {
    protected final String PREFIX_PLACEHOLDER = "[P]";
    protected final String PREFIX_REPLACE = "&7[&6GSit&7]";
    protected final char AMPERSAND_CHAR = (char)38;
    protected final char COLOR_CHAR = (char)167;
    protected final Pattern HEX_PATTERN = Pattern.compile("#([a-fA-F0-9]{6})");
    protected final GSitMain gSitMain;
    protected final HashMap<String, FileConfiguration> messages = new HashMap();
    protected String defaultLanguage;

    public MessageService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.loadMessages();
    }

    public FileConfiguration getMessages() {
        return this.getMessages(this.defaultLanguage);
    }

    public FileConfiguration getMessages(String languageCode) {
        return this.messages.getOrDefault(languageCode, (FileConfiguration)new YamlConfiguration());
    }

    public void loadMessages() {
        this.messages.clear();
        boolean betterSave = this.gSitMain.getVersionManager().isNewerOrVersion(new int[]{1, 18, 2});
        try (JarFile jarFile = new JarFile(Paths.get(((Object)((Object)this.gSitMain)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toString());){
            Enumeration<JarEntry> jarFiles = jarFile.entries();
            while (jarFiles.hasMoreElements()) {
                JarEntry jarEntry = jarFiles.nextElement();
                if (!jarEntry.getName().startsWith("lang") || jarEntry.isDirectory()) continue;
                File langFile = new File(this.gSitMain.getDataFolder(), jarEntry.getName());
                if (!betterSave) {
                    if (langFile.exists()) continue;
                    this.gSitMain.saveResource(jarEntry.getName(), false);
                    continue;
                }
                YamlConfiguration lang = YamlConfiguration.loadConfiguration((File)langFile);
                InputStream langSteam = this.gSitMain.getResource(jarEntry.getName());
                if (langSteam != null) {
                    YamlConfiguration langSteamConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(langSteam, StandardCharsets.UTF_8));
                    if (lang.getKeys(true).equals(langSteamConfig.getKeys(true))) continue;
                    lang.setDefaults((Configuration)langSteamConfig);
                    YamlConfigurationOptions options = (YamlConfigurationOptions)lang.options();
                    options.parseComments(true).copyDefaults(true).width(500);
                    lang.loadFromString(lang.saveToString());
                    for (String comments : lang.getKeys(true)) {
                        lang.setComments(comments, langSteamConfig.getComments(comments));
                    }
                    lang.save(langFile);
                    continue;
                }
                if (langFile.exists()) continue;
                this.gSitMain.saveResource(jarEntry.getName(), false);
            }
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not load messages!", e);
        }
        File langFolder = new File(this.gSitMain.getDataFolder(), "lang");
        for (File langFile : Objects.requireNonNull(langFolder.listFiles())) {
            this.messages.put(langFile.getName().replaceFirst("lang/", "").replaceFirst(".yml", ""), (FileConfiguration)YamlConfiguration.loadConfiguration((File)langFile));
        }
        this.defaultLanguage = this.messages.containsKey(this.gSitMain.getConfigService().L_LANG) ? this.gSitMain.getConfigService().L_LANG : "en_us";
    }

    public abstract String toFormattedMessage(String var1, Object ... var2);

    public abstract void sendMessage(@NotNull CommandSender var1, String var2, Object ... var3);

    public abstract void sendActionBarMessage(@NotNull Player var1, String var2, Object ... var3);

    public String getMessage(String message, Object ... replaceList) {
        return this.getMessage(message, null, replaceList);
    }

    public String getMessage(String message, Entity entity, Object ... replaceList) {
        return this.getTranslatedMessage(message, this.getLanguageForTarget((CommandSender)entity), replaceList);
    }

    public String getTranslatedMessage(String message, String languageCode, Object ... replaceList) {
        return this.toFormattedMessage(this.getRawTranslatedMessage(message, languageCode, replaceList), new Object[0]);
    }

    public String getRawTranslatedMessage(String message, String languageCode, Object ... replaceList) {
        return this.replaceWithLanguageCode(message == null || message.isEmpty() ? "" : this.getMessages(languageCode).getString(message, message), languageCode, replaceList);
    }

    public String getLanguageForTarget(CommandSender target) {
        if (!this.gSitMain.getConfigService().L_CLIENT_LANG || !(target instanceof Player)) {
            return this.defaultLanguage;
        }
        String language = ((Player)target).getLocale();
        return this.messages.containsKey(language) ? language : this.defaultLanguage;
    }

    protected String replaceText(String text, Object ... replaceList) {
        if (replaceList.length == 0 || replaceList.length % 2 != 0) {
            return text;
        }
        for (int count = 0; count < replaceList.length; count += 2) {
            if (replaceList[count] == null || replaceList[count + 1] == null) continue;
            String key = replaceList[count].toString();
            String value = replaceList[count + 1].toString();
            text = text.replace(key, value);
        }
        return text;
    }

    protected String replaceHexColorsDirectly(String text) {
        Matcher matcher = this.HEX_PATTERN.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int lastIndex = 0;
        while (matcher.find()) {
            char[] chars;
            result.append(text, lastIndex, matcher.start()).append('\u00a7').append('x');
            for (char c : chars = matcher.group().substring(1).toCharArray()) {
                result.append('\u00a7').append(c);
            }
            lastIndex = matcher.end();
        }
        result.append(text.substring(lastIndex));
        return result.toString();
    }

    private String replaceWithLanguageCode(String message, String languageCode, Object ... replaceList) {
        message = this.replaceText(message, replaceList);
        return message.replace("[P]", this.getMessages(languageCode).getString("Plugin.plugin-prefix", "&7[&6GSit&7]"));
    }
}

