/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataService {
    protected final int MAX_RETRIES = 3;
    private final GSitMain gSitMain;
    private Connection connection;
    private String type = null;
    private String host = null;
    private String port = null;
    private String database = null;
    private String user = null;
    private String password = null;
    private String args = "";
    private int retries = 0;

    public DataService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean connect() {
        if (this.isConnected()) {
            return true;
        }
        File dataFile = new File(this.gSitMain.getDataFolder(), "data/data.yml");
        if (!dataFile.exists()) {
            this.gSitMain.saveResource("data/data.yml", false);
        }
        YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
        this.type = dataConfig.getString("Database.type", "sqlite").toLowerCase();
        this.host = dataConfig.getString("Database.host", "");
        this.port = dataConfig.getString("Database.port", "");
        this.database = dataConfig.getString("Database.database", "");
        this.user = dataConfig.getString("Database.user", "");
        this.password = dataConfig.getString("Database.password", "");
        this.args = dataConfig.getString("Database.args", "");
        return this.reconnect();
    }

    public boolean isConnected() {
        try {
            if (this.connection != null && !this.connection.isClosed() && this.connection.isValid(5)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    private boolean reconnect() {
        try {
            if (this.type.equals("sqlite")) {
                Class.forName("org.sqlite.JDBC");
            }
            this.connection = this.getConnection(false);
            if (this.connection != null) {
                if (!this.type.equals("sqlite")) {
                    this.connection = this.getConnection(true);
                }
                if (this.connection != null) {
                    this.retries = 0;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not connect to database!", e);
        }
        if (this.retries == 3) {
            return false;
        }
        ++this.retries;
        return this.reconnect();
    }

    private Connection getConnection(boolean withDatabase) throws SQLException {
        switch (this.type) {
            case "mysql": {
                return DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + (String)(withDatabase ? "/" + this.database : "") + "?createDatabaseIfNotExist=true&useUnicode=true" + this.args, this.user, this.password);
            }
            case "sqlite": {
                return DriverManager.getConnection("jdbc:sqlite:" + new File(this.gSitMain.getDataFolder(), "data/data.db").getPath());
            }
        }
        return null;
    }

    public void execute(String query, Object ... parameters) throws SQLException {
        this.ensureConnection();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(query);){
            for (int i = 1; i <= parameters.length; ++i) {
                preparedStatement.setObject(i, parameters[i - 1]);
            }
            preparedStatement.executeUpdate();
        }
    }

    public ResultSet executeAndGet(String query, Object ... parameters) throws SQLException {
        this.ensureConnection();
        PreparedStatement preparedStatement = this.connection.prepareStatement(query);
        for (int i = 1; i <= parameters.length; ++i) {
            preparedStatement.setObject(i, parameters[i - 1]);
        }
        return preparedStatement.executeQuery();
    }

    private void ensureConnection() throws SQLException {
        if (this.isConnected()) {
            return;
        }
        if (this.reconnect()) {
            return;
        }
        if (!this.reconnect()) {
            throw new SQLException("Failed to reconnect to the " + this.type + " database.");
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

