/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.link;

import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.World;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import dev.geco.gsit.GSitMain;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class PlotSquaredLink {
    private final GSitMain gSitMain;

    public PlotSquaredLink(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean canUseSitInLocation(org.bukkit.Location Location2, Player Player2) {
        return this.gSitMain.getEntityUtil().isSitLocationValid(Location2) && this.canUseInLocation(Location2, Player2);
    }

    public boolean canUsePlayerSitInLocation(org.bukkit.Location Location2, Player Player2) {
        return this.gSitMain.getEntityUtil().isPlayerSitLocationValid(Location2) && this.canUseInLocation(Location2, Player2);
    }

    public boolean canUseInLocation(org.bukkit.Location Location2, Player Player2) {
        try {
            PlotAPI plotAPI = new PlotAPI();
            PlotPlayer plotPlayer = plotAPI.wrapPlayer(Player2.getUniqueId());
            if (plotPlayer == null) {
                return true;
            }
            Location location = Location.at((World)plotPlayer.getLocation().getWorld(), (int)Location2.getBlockX(), (int)Location2.getBlockY(), (int)Location2.getBlockZ());
            PlotArea plotArea = plotAPI.getPlotSquared().getPlotAreaManager().getApplicablePlotArea(location);
            if (plotArea == null) {
                return true;
            }
            Plot plot = plotArea.getOwnedPlot(location);
            if (plot == null) {
                return true;
            }
            return !plot.isDenied(Player2.getUniqueId()) && plot.isAdded(Player2.getUniqueId());
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check PlotSquared location!", e);
            return true;
        }
    }

    public boolean isPlotSquaredVersionSupported() {
        try {
            new PlotAPI();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

