/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.event;

import dev.geco.gsit.GSitMain;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SitEventHandler
implements Listener {
    private final GSitMain gSitMain;
    private final Attribute blockInteractionRangeAttribute;

    public SitEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.blockInteractionRangeAttribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"block_interaction_range"));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent event) {
        boolean useCenter;
        double xoffset;
        Block targetBlock;
        BlockFace targetBlockFace;
        Action action = event.getAction();
        if (event.getHand() != EquipmentSlot.HAND || action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getBlockFace() != BlockFace.UP) {
            return;
        }
        if (this.gSitMain.getConfigService().S_EMPTY_HAND_ONLY && event.getItem() != null) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || !this.gSitMain.getPermissionService().hasPermission((Permissible)player, "SitClick", "Sit.*")) {
            return;
        }
        if (!this.gSitMain.getConfigService().S_SITMATERIALS.containsKey(clickedBlock.getType()) && !this.gSitMain.getConfigService().S_SITMATERIALS.containsKey(Material.AIR)) {
            return;
        }
        if (this.gSitMain.getConfigService().MATERIALBLACKLIST.contains(clickedBlock.getType())) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            return;
        }
        if (!player.isValid() || player.isSneaking()) {
            return;
        }
        if (this.gSitMain.getSitService().isEntitySitting((LivingEntity)player) || this.gSitMain.getPoseService().isPlayerPosing(player) || this.gSitMain.getCrawlService().isPlayerCrawling(player)) {
            return;
        }
        double distance = this.gSitMain.getConfigService().S_MAX_DISTANCE;
        Location location = clickedBlock.getLocation();
        if (distance > 0.0 && location.clone().add(0.5, 0.5, 0.5).distanceSquared(player.getLocation()) > distance * distance) {
            return;
        }
        if (!this.gSitMain.getConfigService().ALLOW_UNSAFE && !clickedBlock.getRelative(BlockFace.UP).isPassable()) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(location, player, "sit")) {
            return;
        }
        RayTraceResult targetRayTrack = player.rayTraceBlocks(this.blockInteractionRangeAttribute != null ? player.getAttribute(this.blockInteractionRangeAttribute).getValue() : 5.0);
        BlockFace blockFace = targetBlockFace = targetRayTrack != null ? targetRayTrack.getHitBlockFace() : null;
        if (targetBlockFace != null && targetBlockFace != BlockFace.UP) {
            return;
        }
        Block block = targetBlock = targetRayTrack != null ? targetRayTrack.getHitBlock() : null;
        if (targetBlock != null && !clickedBlock.equals((Object)targetBlock)) {
            return;
        }
        if (!this.gSitMain.getToggleService().canEntityUseSit(player.getUniqueId())) {
            return;
        }
        if (!this.gSitMain.getConfigService().SAME_BLOCK_REST && !this.gSitMain.getSitService().kickSeatEntitiesFromBlock(clickedBlock, (LivingEntity)player)) {
            return;
        }
        if (Tag.STAIRS.isTagged((Keyed)clickedBlock.getType())) {
            if (((Stairs)clickedBlock.getBlockData()).getHalf() == Bisected.Half.BOTTOM) {
                if (this.gSitMain.getSitService().createStairSeatForEntity(clickedBlock, (LivingEntity)player) != null) {
                    event.setCancelled(true);
                    return;
                }
            } else if (this.gSitMain.getConfigService().S_BOTTOM_PART_ONLY) {
                return;
            }
        } else if (Tag.SLABS.isTagged((Keyed)clickedBlock.getType()) && ((Slab)clickedBlock.getBlockData()).getType() != Slab.Type.BOTTOM && this.gSitMain.getConfigService().S_BOTTOM_PART_ONLY) {
            return;
        }
        double zoffset = xoffset = (useCenter = this.gSitMain.getConfigService().CENTER_BLOCK) ? 0.0 : -0.5;
        if (!useCenter) {
            try {
                Vector interactionPointVector = event.getClickedPosition();
                if (interactionPointVector != null) {
                    useCenter = true;
                    xoffset += interactionPointVector.getX() - (double)interactionPointVector.getBlockX();
                    zoffset += interactionPointVector.getZ() - (double)interactionPointVector.getBlockZ();
                }
            }
            catch (Throwable interactionPointVector) {
                // empty catch block
            }
        }
        if (!useCenter) {
            try {
                Location interactionPoint = event.getInteractionPoint();
                if (interactionPoint != null) {
                    useCenter = true;
                    xoffset += interactionPoint.getX() - (double)interactionPoint.getBlockX();
                    zoffset += interactionPoint.getZ() - (double)interactionPoint.getBlockZ();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.gSitMain.getSitService().createSeat(clickedBlock, (LivingEntity)player, true, useCenter ? xoffset : 0.0, 0.0, useCenter ? zoffset : 0.0, player.getLocation().getYaw(), true) != null) {
            event.setCancelled(true);
        }
    }
}

