/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.event;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.permissions.Permissible;

public class PlayerEventHandler
implements Listener {
    private final double MAX_DOUBLE_SNEAK_PITCH = 85.0;
    private final long MAX_DOUBLE_SNEAK_TIME = 400L;
    private final GSitMain gSitMain;
    private final HashMap<Player, Long> doubleSneakCrawlPlayers = new HashMap();

    public PlayerEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        this.gSitMain.getUpdateService().checkForUpdates(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.stopActions(player, StopReason.DISCONNECT, true);
        this.gSitMain.getToggleService().clearEntitySitToggleCache(player.getUniqueId());
        this.doubleSneakCrawlPlayers.remove(player);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerTeleportEvent(PlayerTeleportEvent event) {
        this.stopActions(event.getPlayer(), StopReason.TELEPORT, false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerDeathEvent(PlayerDeathEvent event) {
        this.stopActions(event.getEntity(), StopReason.DEATH, false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void entityDamageEvent(EntityDamageEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                if (!this.gSitMain.getConfigService().GET_UP_DAMAGE || !(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!(event.getDamage() <= 0.0)) break block3;
            }
            return;
        }
        this.stopActions(player, StopReason.DAMAGE, true);
    }

    private void stopActions(Player player, StopReason stopReason, boolean useSafeDismount) {
        Crawl crawl;
        Pose pose;
        Seat seat = this.gSitMain.getSitService().getSeatByEntity((LivingEntity)player);
        if (seat != null) {
            this.gSitMain.getSitService().removeSeat(seat, stopReason, useSafeDismount);
        }
        if ((pose = this.gSitMain.getPoseService().getPoseByPlayer(player)) != null) {
            this.gSitMain.getPoseService().removePose(pose, stopReason, useSafeDismount);
        }
        if ((crawl = this.gSitMain.getCrawlService().getCrawlByPlayer(player)) != null) {
            this.gSitMain.getCrawlService().stopCrawl(crawl, stopReason);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        List<String> commands = this.gSitMain.getConfigService().COMMANDBLACKLIST;
        if (commands.isEmpty()) {
            return;
        }
        String message = event.getMessage();
        Player player = event.getPlayer();
        if (message.length() <= 1 || !this.gSitMain.getSitService().isEntitySitting((LivingEntity)player) && !this.gSitMain.getPoseService().isPlayerPosing(player) && !this.gSitMain.getPlayerSitService().isPlayerInPlayerSitStack(player)) {
            return;
        }
        message = message.substring(1).split(" ")[0].toLowerCase();
        if (commands.stream().noneMatch(message::equalsIgnoreCase) || this.gSitMain.getPermissionService().hasPermission((Permissible)player, "ByPass.Command", "ByPass.*")) {
            return;
        }
        this.gSitMain.getMessageService().sendMessage((CommandSender)player, "Messages.action-blocked-error", new Object[0]);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerToggleSneakEvent(PlayerToggleSneakEvent event) {
        if (!this.gSitMain.getConfigService().C_DOUBLE_SNEAK) {
            return;
        }
        Player player = event.getPlayer();
        if (!event.isSneaking() || (double)player.getLocation().getPitch() < 85.0 || !this.gSitMain.getCrawlService().isAvailable()) {
            return;
        }
        if (!player.isValid() || !player.isOnGround() || player.getVehicle() != null || player.isSleeping() || this.gSitMain.getCrawlService().isPlayerCrawling(player)) {
            return;
        }
        if (!this.gSitMain.getToggleService().canPlayerUseCrawl(player.getUniqueId())) {
            return;
        }
        if (!this.doubleSneakCrawlPlayers.containsKey(player)) {
            this.doubleSneakCrawlPlayers.put(player, System.currentTimeMillis());
            return;
        }
        long last = this.doubleSneakCrawlPlayers.get(player);
        this.doubleSneakCrawlPlayers.put(player, System.currentTimeMillis());
        if (last < System.currentTimeMillis() - 400L) {
            return;
        }
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)player, "CrawlSneak", "Crawl.*")) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(player.getLocation(), player, "crawl")) {
            return;
        }
        this.doubleSneakCrawlPlayers.remove(player);
        this.gSitMain.getCrawlService().startCrawl(player);
    }
}

