/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.api;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GSitAPI {
    @NotNull
    public static GSitMain getInstance() {
        return GSitMain.getInstance();
    }

    public static boolean canEntityUseSit(@NotNull Entity entity) {
        return GSitAPI.getInstance().getToggleService().canEntityUseSit(entity.getUniqueId());
    }

    public static void setEntityCanUseSit(@NotNull Entity entity, boolean canUseSit) {
        GSitAPI.getInstance().getToggleService().setEntityCanUseSit(entity.getUniqueId(), canUseSit);
    }

    public static boolean isEntitySitting(@NotNull LivingEntity entity) {
        return GSitAPI.getInstance().getSitService().isEntitySitting(entity);
    }

    @NotNull
    public static HashMap<UUID, Seat> getAllSeats() {
        return GSitAPI.getInstance().getSitService().getAllSeats();
    }

    @Nullable
    public static Seat getSeatByEntity(@NotNull LivingEntity entity) {
        return GSitAPI.getInstance().getSitService().getSeatByEntity(entity);
    }

    @NotNull
    public static Set<Seat> getSeatsByBlock(@NotNull Block block) {
        return GSitAPI.getInstance().getSitService().getSeatsByBlock(block);
    }

    @Nullable
    public static Seat createSeat(@NotNull Block block, @NotNull LivingEntity entity) {
        return GSitAPI.getInstance().getSitService().createSeat(block, entity);
    }

    @Nullable
    public static Seat createSeat(@NotNull Block block, @NotNull LivingEntity entity, boolean canRotate, float seatRotation, boolean sitInBlockCenter) {
        return GSitAPI.getInstance().getSitService().createSeat(block, entity, canRotate, 0.0, 0.0, 0.0, seatRotation, sitInBlockCenter);
    }

    @Nullable
    public static Seat createSeat(@NotNull Block block, @NotNull LivingEntity entity, boolean canRotate, double xOffset, double yOffset, double zOffset, float seatRotation, boolean sitInBlockCenter) {
        return GSitAPI.getInstance().getSitService().createSeat(block, entity, canRotate, xOffset, yOffset, zOffset, seatRotation, sitInBlockCenter);
    }

    public static void moveSeat(@NotNull Seat seat, @NotNull BlockFace blockDirection) {
        GSitAPI.getInstance().getSitService().moveSeat(seat, blockDirection);
    }

    public static boolean removeSeat(@NotNull Seat seat, @NotNull StopReason stopReason) {
        return GSitAPI.getInstance().getSitService().removeSeat(seat, stopReason);
    }

    public static boolean removeSeat(@NotNull Seat seat, @NotNull StopReason stopReason, boolean useSafeDismount) {
        return GSitAPI.getInstance().getSitService().removeSeat(seat, stopReason, useSafeDismount);
    }

    public static boolean canPlayerUsePlayerSit(@NotNull UUID playerUuid) {
        return GSitAPI.getInstance().getToggleService().canPlayerUsePlayerSit(playerUuid);
    }

    public static void setPlayerCanUsePlayerSit(@NotNull UUID playerUuid, boolean canUsePlayerSit) {
        GSitAPI.getInstance().getToggleService().setPlayerCanUsePlayerSit(playerUuid, canUsePlayerSit);
    }

    public static boolean sitOnPlayer(@NotNull Player player, @NotNull Player target) {
        return GSitAPI.getInstance().getPlayerSitService().sitOnPlayer(player, target);
    }

    public static boolean stopPlayerSit(@NotNull Player player, @NotNull StopReason stopReason) {
        return GSitAPI.getInstance().getPlayerSitService().stopPlayerSit(player, stopReason);
    }

    public static boolean isPlayerPosing(@NotNull Player player) {
        return GSitAPI.getInstance().getPoseService().isPlayerPosing(player);
    }

    @NotNull
    public static HashMap<UUID, Pose> getAllPoses() {
        return GSitAPI.getInstance().getPoseService().getAllPoses();
    }

    @Nullable
    public static Pose getPoseByPlayer(@NotNull Player player) {
        return GSitAPI.getInstance().getPoseService().getPoseByPlayer(player);
    }

    @NotNull
    public static Set<Pose> getPosesByBlock(@NotNull Block block) {
        return GSitAPI.getInstance().getPoseService().getPosesByBlock(block);
    }

    @Nullable
    public static Pose createPose(@NotNull Block block, @NotNull Player player, @NotNull PoseType poseType) {
        return GSitAPI.getInstance().getPoseService().createPose(block, player, poseType);
    }

    @Nullable
    public static Pose createPose(@NotNull Block block, @NotNull Player player, @NotNull PoseType poseType, float seatRotation, boolean sitInBlockCenter) {
        return GSitAPI.getInstance().getPoseService().createPose(block, player, poseType, 0.0, 0.0, 0.0, seatRotation, sitInBlockCenter);
    }

    @Nullable
    public static Pose createPose(@NotNull Block block, @NotNull Player player, @NotNull PoseType poseType, double xOffset, double yOffset, double zOffset, float seatRotation, boolean sitInBlockCenter) {
        return GSitAPI.getInstance().getPoseService().createPose(block, player, poseType, xOffset, yOffset, zOffset, seatRotation, sitInBlockCenter);
    }

    public static boolean removePose(@NotNull Pose pose, @NotNull StopReason stopReason) {
        return GSitAPI.getInstance().getPoseService().removePose(pose, stopReason);
    }

    public static boolean removePose(@NotNull Pose pose, @NotNull StopReason stopReason, boolean useSafeDismount) {
        return GSitAPI.getInstance().getPoseService().removePose(pose, stopReason, useSafeDismount);
    }

    public static boolean isPlayerCrawling(@NotNull Player player) {
        return GSitAPI.getInstance().getCrawlService().isPlayerCrawling(player);
    }

    @NotNull
    public static HashMap<UUID, Crawl> getAllCrawls() {
        return GSitAPI.getInstance().getCrawlService().getAllCrawls();
    }

    @Nullable
    public static Crawl getCrawlByPlayer(@NotNull Player player) {
        return GSitAPI.getInstance().getCrawlService().getCrawlByPlayer(player);
    }

    @Nullable
    public static Crawl startCrawl(@NotNull Player player) {
        return GSitAPI.getInstance().getCrawlService().startCrawl(player);
    }

    public static boolean stopCrawl(@NotNull Crawl crawl, @NotNull StopReason stopReason) {
        return GSitAPI.getInstance().getCrawlService().stopCrawl(crawl, stopReason);
    }
}

