/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.util.EntityUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;

public class LegacyEntityUtil
implements EntityUtil {
    private final GSitMain gSitMain;

    public LegacyEntityUtil(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    @Override
    public void setEntityLocation(Entity entity, Location location) {
        try {
            Method getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
            Object serverEntity = getHandle.invoke((Object)entity, new Object[0]);
            Method setPositionRotationMethod = serverEntity.getClass().getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setPositionRotationMethod.invoke(serverEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not set entity location", e);
        }
    }

    @Override
    public boolean isSitLocationValid(Location location) {
        try {
            Consumer armorStandConsumer = armorStand -> {
                try {
                    armorStand.setInvisible(true);
                }
                catch (Throwable e) {
                    try {
                        ArmorStand.class.getMethod("setVisible", Boolean.TYPE).invoke(armorStand, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    armorStand.setMarker(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
            World world = location.getWorld();
            Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class);
            Entity seatEntity = (Entity)spawnMethod.invoke((Object)world, location, ArmorStand.class, armorStandConsumer);
            boolean valid = seatEntity.isValid();
            seatEntity.remove();
            return valid;
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check sit location", e);
            return false;
        }
    }

    @Override
    public boolean isPlayerSitLocationValid(Location location) {
        try {
            Consumer areaEffectCloudConsumer = areaEffectCloud -> {
                try {
                    areaEffectCloud.setRadius(0.0f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
            World world = location.getWorld();
            Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class);
            Entity playerSitEntity = (Entity)spawnMethod.invoke((Object)world, location, AreaEffectCloud.class, areaEffectCloudConsumer);
            boolean valid = playerSitEntity.isValid();
            playerSitEntity.remove();
            return valid;
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check player sit location", e);
            return false;
        }
    }

    @Override
    public Entity createSeatEntity(Location location, Entity entity, boolean canRotate) {
        try {
            boolean[] riding = new boolean[]{true};
            Consumer consumer = armorStand -> {
                try {
                    armorStand.setInvisible(true);
                }
                catch (Throwable e) {
                    try {
                        ArmorStand.class.getMethod("setVisible", Boolean.TYPE).invoke(armorStand, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    armorStand.setGravity(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    armorStand.setMarker(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    armorStand.setInvulnerable(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    armorStand.setSmall(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    armorStand.setBasePlate(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                armorStand.addScoreboardTag("GSit_SeatEntity");
                if (!this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY && entity != null && entity.isValid()) {
                    riding[0] = armorStand.addPassenger(entity);
                }
            };
            World world = location.getWorld();
            Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class);
            Entity seatEntity = (Entity)spawnMethod.invoke((Object)world, location, ArmorStand.class, consumer);
            if (this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY && entity != null && entity.isValid()) {
                riding[0] = seatEntity.addPassenger(entity);
            }
            if (!(entity == null || !entity.isValid() || riding[0] && seatEntity.getPassengers().contains(entity))) {
                seatEntity.remove();
                return null;
            }
            return seatEntity;
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not spawn entity", e);
            return null;
        }
    }

    @Override
    public Set<UUID> createPlayerSitEntities(Player player, Player target) {
        if (player == null || !player.isValid()) {
            return Collections.emptySet();
        }
        int maxEntities = this.gSitMain.getPlayerSitService().getSitEntityStackCount();
        Player lastEntity = target;
        HashSet<UUID> playerSitEntityIds = new HashSet<UUID>();
        try {
            World world = target.getWorld();
            Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class);
            int entityCount = 1;
            while (entityCount <= maxEntities) {
                Player finalLastEntity = lastEntity;
                int finalEntityCount = entityCount++;
                Consumer areaEffectCloudConsumer = arg_0 -> LegacyEntityUtil.lambda$createPlayerSitEntities$0((Entity)finalLastEntity, finalEntityCount, maxEntities, player, arg_0);
                lastEntity = (Entity)spawnMethod.invoke((Object)world, finalLastEntity.getLocation(), AreaEffectCloud.class, areaEffectCloudConsumer);
                playerSitEntityIds.add(lastEntity.getUniqueId());
            }
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not spawn entity", e);
        }
        return playerSitEntityIds;
    }

    @Override
    public Pose createPose(Seat seat, PoseType poseType) {
        return null;
    }

    @Override
    public Crawl createCrawl(Player player) {
        return null;
    }

    private static /* synthetic */ void lambda$createPlayerSitEntities$0(Entity finalLastEntity, int finalEntityCount, int maxEntities, Player player, AreaEffectCloud areaEffectCloud) {
        try {
            areaEffectCloud.setRadius(0.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            areaEffectCloud.setDuration(Integer.MAX_VALUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            areaEffectCloud.setGravity(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            areaEffectCloud.setInvulnerable(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        areaEffectCloud.addScoreboardTag("GSit_PlayerSitEntity");
        finalLastEntity.addPassenger((Entity)areaEffectCloud);
        if (finalEntityCount == maxEntities) {
            areaEffectCloud.addPassenger((Entity)player);
        }
    }
}

