/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class EnvironmentUtil {
    private final GSitMain gSitMain;

    public EnvironmentUtil(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean isEntityInAllowedWorld(@NotNull Entity entity) {
        boolean allowed;
        boolean bl = allowed = !this.gSitMain.getConfigService().WORLDBLACKLIST.contains(entity.getWorld().getName());
        if (!this.gSitMain.getConfigService().WORLDWHITELIST.isEmpty() && !this.gSitMain.getConfigService().WORLDWHITELIST.contains(entity.getWorld().getName())) {
            allowed = false;
        }
        return allowed || this.gSitMain.getPermissionService().hasPermission((Permissible)entity, "ByPass.World", "ByPass.*");
    }

    public boolean canUseInLocation(@NotNull Location location, @NotNull Player player, @NotNull String flag) {
        if (this.gSitMain.getPermissionService().hasPermission((Permissible)player, "ByPass.Region", "ByPass.*")) {
            return true;
        }
        if (this.gSitMain.getPlotSquaredLink() != null && (flag.equalsIgnoreCase("sit") ? !this.gSitMain.getPlotSquaredLink().canUseSitInLocation(location, player) : (flag.equalsIgnoreCase("playersit") ? !this.gSitMain.getPlotSquaredLink().canUsePlayerSitInLocation(location, player) : !this.gSitMain.getPlotSquaredLink().canUseInLocation(location, player)))) {
            return false;
        }
        if (this.gSitMain.getWorldGuardLink() != null && !this.gSitMain.getWorldGuardLink().canUseInLocation(location, player, flag)) {
            return false;
        }
        return this.gSitMain.getGriefPreventionLink() == null || this.gSitMain.getGriefPreventionLink().canUseInLocation(location, player);
    }
}

