/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_21_11.model;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_21_11.entity.PlayerSitEntity;
import dev.geco.gsit.mcv.v1_21_11.entity.SeatEntity;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;

public class Pose
implements dev.geco.gsit.model.Pose {
    private final GSitMain gSitMain = GSitMain.getInstance();
    private final Seat seat;
    private final Player seatPlayer;
    private final PoseType poseType;
    private Set<Player> nearbyPlayers = new HashSet<Player>();
    private final ServerPlayer serverPlayer;
    protected final ServerPlayer playerNpc;
    private final PlayerSitEntity hideNameEntity;
    private final Location blockLocation;
    private final Block bedBlock;
    private final BlockPos bedPos;
    private final double height;
    private final Direction direction;
    protected ClientboundBlockUpdatePacket setBedPacket;
    protected ClientboundPlayerInfoUpdatePacket addNpcInfoPacket;
    protected ClientboundPlayerInfoRemovePacket removeNpcInfoPacket;
    protected ClientboundRemoveEntitiesPacket removeNpcPacket;
    protected ClientboundAddEntityPacket createNpcPacket;
    protected ClientboundSetEntityDataPacket metaNpcPacket;
    protected ClientboundUpdateAttributesPacket attributeNpcPacket;
    protected ClientboundTeleportEntityPacket teleportNpcPacket;
    protected ClientboundMoveEntityPacket.PosRot rotateNpcPacket;
    protected ClientboundBundlePacket bundle;
    private NonNullList<ItemStack> equipmentSlotCache;
    private ItemStack mainSlotCache;
    private float directionCache;
    private boolean sleepingIgnoredCache;
    protected int renderRange;
    private final Listener listener;
    private static final EntityDataAccessor<net.minecraft.world.entity.Pose> POSE_ACCESSOR = EntityDataSerializers.POSE.createAccessor(6);
    private static final EntityDataAccessor<Byte> DATA_FLAG_ACCESSOR = EntityDataSerializers.BYTE.createAccessor(8);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEP_BLOCK_POS_ACCESSOR = EntityDataSerializers.OPTIONAL_BLOCK_POS.createAccessor(14);
    private static final EntityDataAccessor<HumanoidArm> MAIN_HAND_ACCESSOR = EntityDataSerializers.HUMANOID_ARM.createAccessor(15);
    private static final EntityDataAccessor<Byte> SKIN_ACCESSOR = EntityDataSerializers.BYTE.createAccessor(16);
    private static final EntityDataAccessor<OptionalInt> LEFT_SHOULDER_ACCESSOR = EntityDataSerializers.OPTIONAL_UNSIGNED_INT.createAccessor(19);
    private static final EntityDataAccessor<OptionalInt> RIGHT_SHOULDER_ACCESSOR = EntityDataSerializers.OPTIONAL_UNSIGNED_INT.createAccessor(20);

    public Pose(Seat seat, PoseType poseType) {
        this.seat = seat;
        this.seatPlayer = (Player)seat.getEntity();
        this.poseType = poseType;
        this.serverPlayer = ((CraftPlayer)this.seatPlayer).getHandle();
        this.renderRange = this.seatPlayer.getWorld().getSimulationDistance() * 16;
        Location seatLocation = seat.getLocation();
        this.blockLocation = seatLocation.clone();
        this.blockLocation.setY((double)this.blockLocation.getWorld().getMinHeight());
        this.bedBlock = this.blockLocation.getBlock();
        this.bedPos = new BlockPos(this.blockLocation.getBlockX(), this.blockLocation.getBlockY(), this.blockLocation.getBlockZ());
        this.playerNpc = this.createNPC();
        this.height = seatLocation.getY() + this.gSitMain.getSitService().getBaseOffset();
        double scale = this.serverPlayer.getScale();
        double offset = this.height;
        if (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK) {
            offset += 0.1125 * scale;
        }
        if (poseType == PoseType.BELLYFLOP) {
            offset += -0.19 * scale;
        }
        this.playerNpc.absSnapTo(seatLocation.getX(), offset, seatLocation.getZ(), 0.0f, 0.0f);
        this.direction = this.getDirection();
        if (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK) {
            this.setBedPacket = new ClientboundBlockUpdatePacket(this.bedPos, (BlockState)((BlockState)Blocks.WHITE_BED.defaultBlockState().setValue((Property)BedBlock.FACING, (Comparable)this.direction.getOpposite())).setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD));
        }
        this.addNpcInfoPacket = new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME), Collections.singletonList(this.playerNpc));
        this.removeNpcInfoPacket = new ClientboundPlayerInfoRemovePacket(Collections.singletonList(this.playerNpc.getUUID()));
        this.removeNpcPacket = new ClientboundRemoveEntitiesPacket(new int[]{this.playerNpc.getId()});
        this.createNpcPacket = new ClientboundAddEntityPacket(this.playerNpc.getId(), this.playerNpc.getUUID(), this.playerNpc.getX(), this.playerNpc.getY(), this.playerNpc.getZ(), this.playerNpc.getXRot(), this.playerNpc.getYRot(), this.playerNpc.getType(), 0, this.playerNpc.getDeltaMovement(), (double)this.playerNpc.getYHeadRot());
        if (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK) {
            this.teleportNpcPacket = new ClientboundTeleportEntityPacket(this.playerNpc.getId(), PositionMoveRotation.of((net.minecraft.world.entity.Entity)this.playerNpc), Set.of(), false);
        }
        if (poseType == PoseType.SPIN) {
            this.rotateNpcPacket = new ClientboundMoveEntityPacket.PosRot(this.playerNpc.getId(), 0, 0, 0, 0, this.getFixedRotation(-90.0f), true);
        }
        this.hideNameEntity = new PlayerSitEntity(this.seatPlayer.getLocation());
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEvent(PlayerInteractEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEntityEvent(PlayerInteractEntityEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityDamageByEntityEvent(EntityDamageByEntityEvent Event2) {
                if (Event2.getDamager() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void entityDamageEvent(EntityDamageEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.playAnimation(1);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void projectileLaunchEvent(ProjectileLaunchEvent Event2) {
                if (Event2.getEntity().getShooter() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerAnimationEvent(PlayerAnimationEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Event2.getAnimationType() == PlayerAnimationType.ARM_SWING) {
                    Pose.this.playAnimation(Event2.getPlayer().getMainHand().equals((Object)MainHand.RIGHT) ? 0 : 3);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void inventoryClickEvent(InventoryClickEvent Event2) {
                if (Event2.getWhoClicked() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerDropItemEvent(PlayerDropItemEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityPotionEffectEvent(EntityPotionEffectEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.serverPlayer.setInvisible(true);
                }
            }
        };
    }

    @Override
    public void spawn() {
        this.nearbyPlayers = this.getNearbyPlayers();
        this.playerNpc.setGlowingTag(this.serverPlayer.hasGlowingTag());
        if (this.serverPlayer.hasGlowingTag()) {
            this.serverPlayer.setGlowingTag(false);
        }
        this.playerNpc.getEntityData().set(POSE_ACCESSOR, (Object)net.minecraft.world.entity.Pose.values()[this.poseType.getPlayerPose().ordinal()]);
        if (this.poseType == PoseType.SPIN) {
            this.playerNpc.getEntityData().set(DATA_FLAG_ACCESSOR, (Object)4);
        }
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            this.playerNpc.getEntityData().set(SLEEP_BLOCK_POS_ACCESSOR, Optional.of(this.bedPos));
        }
        this.playerNpc.getEntityData().set(MAIN_HAND_ACCESSOR, (Object)((HumanoidArm)this.serverPlayer.getEntityData().get(MAIN_HAND_ACCESSOR)));
        this.playerNpc.getEntityData().set(SKIN_ACCESSOR, (Object)((Byte)this.serverPlayer.getEntityData().get(SKIN_ACCESSOR)));
        this.playerNpc.getEntityData().set(LEFT_SHOULDER_ACCESSOR, (Object)((OptionalInt)this.serverPlayer.getEntityData().get(LEFT_SHOULDER_ACCESSOR)));
        this.playerNpc.getEntityData().set(RIGHT_SHOULDER_ACCESSOR, (Object)((OptionalInt)this.serverPlayer.getEntityData().get(RIGHT_SHOULDER_ACCESSOR)));
        this.serverPlayer.getEntityData().set(LEFT_SHOULDER_ACCESSOR, (Object)OptionalInt.empty());
        this.serverPlayer.getEntityData().set(RIGHT_SHOULDER_ACCESSOR, (Object)OptionalInt.empty());
        this.serverPlayer.setInvisible(true);
        this.setEquipmentVisibility(false);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            this.sleepingIgnoredCache = this.seatPlayer.isSleepingIgnored();
            if (this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP && !this.sleepingIgnoredCache) {
                this.seatPlayer.setSleepingIgnored(true);
            }
            if (this.gSitMain.getConfigService().P_LAY_REST) {
                this.seatPlayer.setStatistic(Statistic.TIME_SINCE_REST, 0);
            }
        }
        this.metaNpcPacket = new ClientboundSetEntityDataPacket(this.playerNpc.getId(), this.playerNpc.getEntityData().isDirty() ? this.playerNpc.getEntityData().packDirty() : this.playerNpc.getEntityData().getNonDefaultValues());
        this.attributeNpcPacket = new ClientboundUpdateAttributesPacket(this.playerNpc.getId(), this.serverPlayer.getAttributes().getSyncableAttributes());
        ArrayList<Object> packages = new ArrayList<Object>();
        packages.add(this.addNpcInfoPacket);
        packages.add(this.createNpcPacket);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            packages.add(this.setBedPacket);
        }
        packages.add(this.metaNpcPacket);
        packages.add(this.attributeNpcPacket);
        if (this.poseType == PoseType.SPIN) {
            packages.add(this.rotateNpcPacket);
        }
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            packages.add(this.teleportNpcPacket);
        }
        this.bundle = new ClientboundBundlePacket(packages);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.addViewerPlayer(nearbyPlayer);
        }
        this.hideNameEntity.setVehicle((net.minecraft.world.entity.Entity)this.playerNpc);
        ArrayList<Object> playerPackages = new ArrayList<Object>();
        playerPackages.add(new ClientboundAddEntityPacket(this.hideNameEntity.getId(), this.hideNameEntity.getUUID(), this.hideNameEntity.getX(), this.hideNameEntity.getY(), this.hideNameEntity.getZ(), this.hideNameEntity.getXRot(), this.hideNameEntity.getYRot(), this.hideNameEntity.getType(), 0, this.hideNameEntity.getDeltaMovement(), (double)this.hideNameEntity.getYHeadRot()));
        playerPackages.add(new ClientboundSetEntityDataPacket(this.hideNameEntity.getId(), this.hideNameEntity.getEntityData().getNonDefaultValues()));
        playerPackages.add(new ClientboundSetPassengersPacket((net.minecraft.world.entity.Entity)this.playerNpc));
        this.sendPacket(this.serverPlayer, (Packet<?>)new ClientboundBundlePacket(playerPackages));
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gSitMain);
        ((SeatEntity)((CraftEntity)this.seat.getSeatEntity()).getHandle()).setRunnable(() -> {
            Set<Player> currentNearbyPlayers = this.getNearbyPlayers();
            for (Player nearbyPlayer : currentNearbyPlayers) {
                if (this.nearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.add(nearbyPlayer);
                this.addViewerPlayer(nearbyPlayer);
            }
            for (Player nearbyPlayer : new ArrayList<Player>(this.nearbyPlayers)) {
                if (currentNearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.remove(nearbyPlayer);
                this.removeViewerPlayer(nearbyPlayer);
            }
            if (this.poseType != PoseType.SPIN) {
                this.updateDirection();
            }
            this.serverPlayer.setInvisible(true);
            this.updateEquipment();
            this.setEquipmentVisibility(false);
            this.updateSkin();
            if (this.poseType != PoseType.LAY && this.poseType != PoseType.LAY_BACK || !this.gSitMain.getConfigService().P_LAY_SNORING_SOUNDS) {
                return;
            }
            long tick = this.serverPlayer.getPlayerTime();
            if ((!this.gSitMain.getConfigService().P_LAY_SNORING_NIGHT_ONLY || tick >= 12500L && tick <= 23500L) && tick % 90L == 0L) {
                for (Player nearbyPlayer : this.nearbyPlayers) {
                    nearbyPlayer.playSound(this.seat.getLocation(), Sound.ENTITY_FOX_SLEEP, SoundCategory.PLAYERS, 1.5f, 0.0f);
                }
            }
        });
    }

    private void addViewerPlayer(Player player) {
        this.sendPacket(player, (Packet<?>)this.bundle);
        if (this.poseType != PoseType.LAY && this.poseType != PoseType.LAY_BACK || this.height < 1.0) {
            return;
        }
        this.gSitMain.getTaskService().runDelayed(() -> {
            this.sendPacket(player, (Packet<?>)this.teleportNpcPacket);
            this.gSitMain.getTaskService().runDelayed(() -> this.sendPacket(player, (Packet<?>)this.teleportNpcPacket), (Entity)player, 1L);
        }, (Entity)player, 1L);
    }

    @Override
    public void remove() {
        ((SeatEntity)((CraftEntity)this.seat.getSeatEntity()).getHandle()).setRunnable(null);
        HandlerList.unregisterAll((Listener)this.listener);
        this.seatPlayer.removeScoreboardTag("GSit_POSE");
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.removeViewerPlayer(nearbyPlayer);
        }
        this.sendPacket(this.serverPlayer, (Packet<?>)new ClientboundRemoveEntitiesPacket(new int[]{this.hideNameEntity.getId()}));
        if ((this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) && this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP && !this.sleepingIgnoredCache) {
            this.seatPlayer.setSleepingIgnored(false);
        }
        if (!this.serverPlayer.activeEffects.containsKey(MobEffects.INVISIBILITY)) {
            this.serverPlayer.setInvisible(false);
        }
        this.setEquipmentVisibility(true);
        this.serverPlayer.getEntityData().set(LEFT_SHOULDER_ACCESSOR, (Object)((OptionalInt)this.playerNpc.getEntityData().get(LEFT_SHOULDER_ACCESSOR)));
        this.serverPlayer.getEntityData().set(RIGHT_SHOULDER_ACCESSOR, (Object)((OptionalInt)this.playerNpc.getEntityData().get(RIGHT_SHOULDER_ACCESSOR)));
        this.serverPlayer.setGlowingTag(this.playerNpc.hasGlowingTag());
    }

    private void removeViewerPlayer(Player player) {
        ServerPlayer removePlayer = ((CraftPlayer)player).getHandle();
        this.sendPacket(removePlayer, (Packet<?>)this.removeNpcInfoPacket);
        this.sendPacket(removePlayer, (Packet<?>)this.removeNpcPacket);
        player.sendBlockChange(this.blockLocation, this.bedBlock.getBlockData());
    }

    private Set<Player> getNearbyPlayers() {
        HashSet<Player> currentNearbyPlayers = new HashSet<Player>();
        this.seatPlayer.getWorld().getPlayers().stream().filter(player -> this.seat.getLocation().distanceSquared(player.getLocation()) <= (double)(this.renderRange * this.renderRange) && player.canSee(this.seatPlayer)).forEach(currentNearbyPlayers::add);
        return currentNearbyPlayers;
    }

    private float fixYaw(float yaw) {
        return (yaw < 0.0f ? 360.0f + yaw : yaw) % 360.0f;
    }

    private void updateDirection() {
        if (this.poseType == PoseType.BELLYFLOP) {
            byte fixedRotation = this.getFixedRotation(this.seatPlayer.getLocation().getYaw());
            if (this.directionCache == (float)fixedRotation) {
                return;
            }
            this.directionCache = fixedRotation;
            ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket((net.minecraft.world.entity.Entity)this.playerNpc, fixedRotation);
            ClientboundMoveEntityPacket.PosRot moveEntityPacket = new ClientboundMoveEntityPacket.PosRot(this.playerNpc.getId(), 0, 0, 0, fixedRotation, 0, true);
            for (Player nearbyPlayer : this.nearbyPlayers) {
                ServerPlayer player = ((CraftPlayer)nearbyPlayer).getHandle();
                this.sendPacket(player, (Packet<?>)rotateHeadPacket);
                this.sendPacket(player, (Packet<?>)moveEntityPacket);
            }
            return;
        }
        float playerYaw = this.seatPlayer.getLocation().getYaw();
        if (this.directionCache == playerYaw) {
            return;
        }
        this.directionCache = playerYaw;
        if (this.direction == Direction.WEST) {
            playerYaw -= 90.0f;
        }
        if (this.direction == Direction.EAST) {
            playerYaw += 90.0f;
        }
        if (this.direction == Direction.NORTH) {
            playerYaw -= 180.0f;
        }
        byte fixedRotation = this.getFixedRotation((playerYaw = this.fixYaw(playerYaw)) >= 315.0f ? playerYaw - 360.0f : (playerYaw <= 45.0f ? playerYaw : (playerYaw >= 180.0f ? -45.0f : 45.0f)));
        ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket((net.minecraft.world.entity.Entity)this.playerNpc, fixedRotation);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)rotateHeadPacket);
        }
    }

    private void updateSkin() {
        this.playerNpc.setInvisible(this.serverPlayer.activeEffects.containsKey(MobEffects.INVISIBILITY));
        SynchedEntityData entityData = this.playerNpc.getEntityData();
        entityData.set(MAIN_HAND_ACCESSOR, (Object)((HumanoidArm)this.serverPlayer.getEntityData().get(MAIN_HAND_ACCESSOR)));
        entityData.set(SKIN_ACCESSOR, (Object)((Byte)this.serverPlayer.getEntityData().get(SKIN_ACCESSOR)));
        if (!entityData.isDirty()) {
            return;
        }
        ClientboundSetEntityDataPacket entityDataPacket = new ClientboundSetEntityDataPacket(this.playerNpc.getId(), entityData.packDirty());
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)entityDataPacket);
        }
    }

    private void updateEquipment() {
        ItemStack mainItemStack = this.serverPlayer.getItemBySlot(EquipmentSlot.MAINHAND);
        if (this.equipmentSlotCache != null && this.equipmentSlotCache.equals((Object)this.serverPlayer.getInventory().getContents()) && this.mainSlotCache == mainItemStack) {
            return;
        }
        this.equipmentSlotCache = NonNullList.create();
        this.equipmentSlotCache.addAll((Collection)this.serverPlayer.getInventory().getContents());
        this.mainSlotCache = mainItemStack;
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.serverPlayer.getItemBySlot(equipmentSlot);
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)itemStack));
        }
        ClientboundSetEquipmentPacket setEquipmentPacket = new ClientboundSetEquipmentPacket(this.playerNpc.getId(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
        this.serverPlayer.containerMenu.sendAllDataToRemote();
    }

    private void setEquipmentVisibility(boolean visibility) {
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = visibility ? this.serverPlayer.getItemBySlot(equipmentSlot) : null;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)(itemStack != null ? itemStack : ItemStack.EMPTY)));
        }
        ClientboundSetEquipmentPacket setEquipmentPacket = new ClientboundSetEquipmentPacket(this.serverPlayer.getId(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
    }

    private void playAnimation(int animationId) {
        ClientboundAnimatePacket animatePacket = new ClientboundAnimatePacket((net.minecraft.world.entity.Entity)this.playerNpc, animationId);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)animatePacket);
        }
    }

    private byte getFixedRotation(float rotation) {
        return (byte)(rotation * 256.0f / 360.0f);
    }

    private Direction getDirection() {
        float yaw = this.seat.getLocation().getYaw();
        return yaw >= 135.0f || yaw < -135.0f ? Direction.NORTH : (yaw >= -135.0f && yaw < -45.0f ? Direction.EAST : (yaw >= -45.0f && yaw < 45.0f ? Direction.SOUTH : (yaw >= 45.0f ? Direction.WEST : Direction.NORTH)));
    }

    private ServerPlayer createNPC() {
        DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
        ServerLevel serverLevel = ((CraftWorld)this.seat.getLocation().getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), this.seatPlayer.getName(), this.serverPlayer.getGameProfile().properties());
        ClientInformation clientInformation = this.serverPlayer.clientInformation();
        ServerPlayer npc = new ServerPlayer((MinecraftServer)minecraftServer, serverLevel, gameProfile, clientInformation);
        npc.connection = this.serverPlayer.connection;
        return npc;
    }

    private void sendPacket(Player player, Packet<?> packet) {
        this.sendPacket(((CraftPlayer)player).getHandle(), packet);
    }

    private void sendPacket(ServerPlayer player, Packet<?> packet) {
        player.connection.send(packet);
    }

    @Override
    public Seat getSeat() {
        return this.seat;
    }

    @Override
    public Player getPlayer() {
        return this.seatPlayer;
    }

    @Override
    public PoseType getPoseType() {
        return this.poseType;
    }

    public String toString() {
        return this.seat.toString();
    }
}

