/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.link.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.link.WorldGuardLink;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.StopReason;
import java.util.Set;

public class RegionFlagHandler
extends Handler {
    public static final Factory FACTORY = new Factory();
    private final GSitMain gSitMain = GSitMain.getInstance();
    private StateFlag.State currentPlayerSitFlagState = null;
    private StateFlag.State currentCrawlFlagState = null;

    public RegionFlagHandler(Session session) {
        super(session);
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        StateFlag.State crawlFlagState;
        StateFlag.State playerSitFlagState = toSet.queryState((RegionAssociable)player, new StateFlag[]{WorldGuardLink.PLAYERSIT_FLAG});
        if (playerSitFlagState != this.currentPlayerSitFlagState) {
            this.currentPlayerSitFlagState = playerSitFlagState;
            this.handlePlayerSitFlagChange(player);
        }
        if ((crawlFlagState = toSet.queryState((RegionAssociable)player, new StateFlag[]{WorldGuardLink.CRAWL_FLAG})) != this.currentCrawlFlagState) {
            this.currentCrawlFlagState = crawlFlagState;
            this.handleCrawlFlagChange(player);
        }
        return true;
    }

    private void handlePlayerSitFlagChange(LocalPlayer localPlayer) {
        if (this.currentPlayerSitFlagState != StateFlag.State.DENY) {
            return;
        }
        this.gSitMain.getPlayerSitService().stopPlayerSit(BukkitAdapter.adapt((Player)localPlayer), StopReason.REGION);
    }

    private void handleCrawlFlagChange(LocalPlayer localPlayer) {
        if (this.currentCrawlFlagState != StateFlag.State.DENY) {
            return;
        }
        Crawl crawl = this.gSitMain.getCrawlService().getCrawlByPlayer(BukkitAdapter.adapt((Player)localPlayer));
        if (crawl == null) {
            return;
        }
        this.gSitMain.getCrawlService().stopCrawl(crawl, StopReason.REGION);
    }

    public static class Factory
    extends Handler.Factory<RegionFlagHandler> {
        public RegionFlagHandler create(Session session) {
            return new RegionFlagHandler(session);
        }
    }
}

