/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.link;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.handler.Handler;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.link.worldguard.RegionFlagHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardLink {
    public static final StateFlag SIT_FLAG = new StateFlag("sit", true);
    public static final StateFlag PLAYERSIT_FLAG = new StateFlag("playersit", true);
    public static final StateFlag POSE_FLAG = new StateFlag("pose", true);
    public static final StateFlag CRAWL_FLAG = new StateFlag("crawl", true);

    public void registerFlags() {
        HashMap<String, StateFlag> flags = new HashMap<String, StateFlag>();
        flags.put(SIT_FLAG.getName(), SIT_FLAG);
        flags.put(PLAYERSIT_FLAG.getName(), PLAYERSIT_FLAG);
        flags.put(POSE_FLAG.getName(), POSE_FLAG);
        flags.put(CRAWL_FLAG.getName(), CRAWL_FLAG);
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        for (Map.Entry flag : flags.entrySet()) {
            try {
                flagRegistry.register((Flag)flag.getValue());
            }
            catch (Throwable throwable) {}
        }
    }

    public void registerFlagHandlers() {
        WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)RegionFlagHandler.FACTORY, null);
    }

    public void unregisterFlagHandlers() {
        WorldGuard.getInstance().getPlatform().getSessionManager().unregisterHandler((Handler.Factory)RegionFlagHandler.FACTORY);
    }

    public boolean canUseInLocation(Location location, Player player, String flag) {
        try {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            if (container.get(BukkitAdapter.adapt((World)location.getWorld())) == null) {
                return true;
            }
            RegionQuery regionQuery = container.createQuery();
            com.sk89q.worldedit.util.Location regionLocation = BukkitAdapter.adapt((Location)location);
            FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
            Flag flag2 = flagRegistry.get(flag);
            if (!(flag2 instanceof StateFlag)) {
                return true;
            }
            StateFlag stateFlag = (StateFlag)flag2;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            return regionQuery.testState(regionLocation, localPlayer, new StateFlag[]{stateFlag});
        }
        catch (Throwable e) {
            GSitMain.getInstance().getLogger().log(Level.SEVERE, "Could not check WorldGuard location!", e);
            return true;
        }
    }
}

