/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.event;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockEventHandler
implements Listener {
    private final GSitMain gSitMain;

    public BlockEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockPistonExtendEvent(BlockPistonExtendEvent event) {
        this.handleBlockPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockPistonRetractEvent(BlockPistonRetractEvent event) {
        this.handleBlockPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void handleBlockPistonEvent(BlockPistonEvent event, List<Block> blocks) {
        HashSet<Seat> moveList = new HashSet<Seat>();
        HashSet<Pose> breakList = new HashSet<Pose>();
        for (Block block : blocks) {
            moveList.addAll(this.gSitMain.getSitService().getSeatsByBlock(block));
            if (!this.gSitMain.getConfigService().GET_UP_BREAK) continue;
            breakList.addAll(this.gSitMain.getPoseService().getPosesByBlock(block));
        }
        for (Seat seat : moveList) {
            this.gSitMain.getSitService().moveSeat(seat, event.getDirection());
        }
        for (Pose pose : breakList) {
            this.gSitMain.getPoseService().removePose(pose, StopReason.BLOCK_BREAK);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockExplodeEvent(BlockExplodeEvent event) {
        this.handleExplodeEvent(event.blockList());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void entityExplodeEvent(EntityExplodeEvent event) {
        this.handleExplodeEvent(event.blockList());
    }

    private void handleExplodeEvent(List<Block> blocks) {
        if (!this.gSitMain.getConfigService().GET_UP_BREAK) {
            return;
        }
        block0: for (Block block : new ArrayList<Block>(blocks)) {
            for (Seat seat : this.gSitMain.getSitService().getSeatsByBlock(block)) {
                if (this.gSitMain.getSitService().removeSeat(seat, StopReason.BLOCK_BREAK)) continue;
                blocks.remove(block);
                continue block0;
            }
            for (Pose pose : this.gSitMain.getPoseService().getPosesByBlock(block)) {
                if (this.gSitMain.getPoseService().removePose(pose, StopReason.BLOCK_BREAK)) continue;
                blocks.remove(block);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockFadeEvent(BlockFadeEvent event) {
        this.handleBlockEvent((Cancellable)event, event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void leavesDecayEvent(LeavesDecayEvent event) {
        this.handleBlockEvent((Cancellable)event, event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockBurnEvent(BlockBurnEvent event) {
        this.handleBlockEvent((Cancellable)event, event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void entityChangeBlockEvent(EntityChangeBlockEvent event) {
        this.handleBlockEvent((Cancellable)event, event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockBreakEvent(BlockBreakEvent event) {
        this.handleBlockEvent((Cancellable)event, event.getBlock());
    }

    private void handleBlockEvent(Cancellable event, Block block) {
        if (!this.gSitMain.getConfigService().GET_UP_BREAK) {
            return;
        }
        for (Seat seat : this.gSitMain.getSitService().getSeatsByBlock(block)) {
            if (this.gSitMain.getSitService().removeSeat(seat, StopReason.BLOCK_BREAK)) continue;
            event.setCancelled(true);
        }
        if (!event.isCancelled()) {
            for (Pose pose : this.gSitMain.getPoseService().getPosesByBlock(block)) {
                if (this.gSitMain.getPoseService().removePose(pose, StopReason.BLOCK_BREAK)) continue;
                event.setCancelled(true);
            }
        }
    }
}

