/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_21_9.model;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_21_9.entity.BoxEntity;
import dev.geco.gsit.model.StopReason;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.PositionMoveRotation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class Crawl
implements dev.geco.gsit.model.Crawl {
    private final GSitMain gSitMain = GSitMain.getInstance();
    private final Player player;
    private final EntityPlayer serverPlayer;
    protected final BoxEntity boxEntity;
    private boolean boxEntityExist = false;
    private final Listener listener;
    private final Listener moveListener;
    private final Listener stopListener;
    private boolean finished = false;
    private final long spawnTime = System.nanoTime();

    public Crawl(final Player player) {
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.boxEntity = new BoxEntity(player.getLocation());
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityToggleSwimEvent(EntityToggleSwimEvent event) {
                if (event.getEntity() == player) {
                    event.setCancelled(true);
                }
            }
        };
        this.moveListener = new Listener(){
            final /* synthetic */ Crawl this$0;
            {
                this.this$0 = this$0;
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerMoveEvent(PlayerMoveEvent event) {
                if (event.isAsynchronous() || event.getPlayer() != player) {
                    return;
                }
                Location fromLocation = event.getFrom();
                Location toLocation = event.getTo();
                if (fromLocation.getX() != toLocation.getX() || fromLocation.getZ() != toLocation.getZ() || fromLocation.getY() != toLocation.getY()) {
                    this.this$0.tick(toLocation);
                }
            }
        };
        this.stopListener = new Listener(){
            final /* synthetic */ Crawl this$0;
            {
                this.this$0 = this$0;
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerToggleSneakEvent(PlayerToggleSneakEvent event) {
                if (!event.isAsynchronous() && event.getPlayer() == player && event.isSneaking()) {
                    this.this$0.gSitMain.getCrawlService().stopCrawl(this.this$0, StopReason.GET_UP);
                }
            }
        };
    }

    @Override
    public void start() {
        this.player.setSwimming(true);
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gSitMain);
        this.gSitMain.getTaskService().runDelayed(() -> {
            Bukkit.getPluginManager().registerEvents(this.moveListener, (Plugin)this.gSitMain);
            if (this.gSitMain.getConfigService().C_GET_UP_SNEAK) {
                Bukkit.getPluginManager().registerEvents(this.stopListener, (Plugin)this.gSitMain);
            }
            this.tick(this.player.getLocation());
        }, false, (Entity)this.player, 1L);
    }

    private void tick(Location location) {
        boolean hasSolidBlockAbove;
        if (this.finished || !this.checkCrawlValid()) {
            return;
        }
        Location tickLocation = location.clone();
        Block locationBlock = tickLocation.getBlock();
        int blockSize = (int)((tickLocation.getY() - (double)tickLocation.getBlockY()) * 100.0);
        tickLocation.setY((double)tickLocation.getBlockY() + (blockSize >= 40 ? 2.49 : 1.49));
        Block aboveBlock = tickLocation.getBlock();
        boolean bl = hasSolidBlockAbove = aboveBlock.getBoundingBox().contains(tickLocation.toVector()) && !aboveBlock.getCollisionShape().getBoundingBoxes().isEmpty();
        if (hasSolidBlockAbove) {
            this.destoryEntity();
            return;
        }
        Location playerLocation = location.clone();
        this.gSitMain.getTaskService().run(() -> {
            if (this.finished) {
                return;
            }
            int height = locationBlock.getBoundingBox().getHeight() >= 0.4 || playerLocation.getY() % 0.015625 == 0.0 ? ((double)this.player.getFallDistance() > 0.7 ? 0 : blockSize) : 0;
            playerLocation.setY(playerLocation.getY() + (height >= 40 ? 1.5 : 0.5));
            this.boxEntity.b(height >= 40 ? 100 - height : 0);
            if (!this.boxEntityExist) {
                this.boxEntity.a_(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                this.serverPlayer.g.b((Packet)new PacketPlayOutSpawnEntity(this.boxEntity.az(), this.boxEntity.cT(), this.boxEntity.dK(), this.boxEntity.dM(), this.boxEntity.dQ(), this.boxEntity.dZ(), this.boxEntity.dX(), this.boxEntity.ax(), 0, this.boxEntity.dI(), (double)this.boxEntity.cN()));
                this.boxEntityExist = true;
                this.serverPlayer.g.b((Packet)new PacketPlayOutEntityMetadata(this.boxEntity.az(), this.boxEntity.aC().c()));
            } else {
                this.serverPlayer.g.b((Packet)new PacketPlayOutEntityMetadata(this.boxEntity.az(), this.boxEntity.aC().c()));
                this.boxEntity.n(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                this.serverPlayer.g.b((Packet)new PacketPlayOutEntityTeleport(this.boxEntity.az(), PositionMoveRotation.a((net.minecraft.world.entity.Entity)this.boxEntity), Set.of(), false));
            }
        }, true, playerLocation);
    }

    @Override
    public void stop() {
        this.finished = true;
        HandlerList.unregisterAll((Listener)this.listener);
        HandlerList.unregisterAll((Listener)this.moveListener);
        HandlerList.unregisterAll((Listener)this.stopListener);
        this.player.setSwimming(false);
        this.destoryEntity();
    }

    private void destoryEntity() {
        if (!this.boxEntityExist) {
            return;
        }
        this.serverPlayer.g.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.boxEntity.az()}));
        this.boxEntityExist = false;
    }

    private boolean checkCrawlValid() {
        if (this.serverPlayer.bu() || this.player.isFlying()) {
            this.gSitMain.getCrawlService().stopCrawl(this, StopReason.ENVIRONMENT);
            return false;
        }
        return true;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public long getLifetimeInNanoSeconds() {
        return System.nanoTime() - this.spawnTime;
    }

    public String toString() {
        return this.boxEntity.cT().toString();
    }
}

