/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.event;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.StopReason;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.permissions.Permissible;

public class PlayerSitEventHandler
implements Listener {
    private final GSitMain gSitMain;

    public PlayerSitEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerToggleSneakEvent(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!this.gSitMain.getConfigService().PS_SNEAK_EJECTS || !event.isSneaking() || player.isFlying() || player.getVehicle() != null || this.gSitMain.getPlayerSitService().getPreventDismountStackPlayers().contains(player) || player.getPassengers().isEmpty()) {
            return;
        }
        this.gSitMain.getPlayerSitService().stopPlayerSit(player, StopReason.KICKED, true, false, true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerGameModeChangeEvent(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.SPECTATOR) {
            this.gSitMain.getPlayerSitService().stopPlayerSit(event.getPlayer(), StopReason.GAMEMODE_CHANGE);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerDeathEvent(PlayerDeathEvent event) {
        this.gSitMain.getPlayerSitService().stopPlayerSit(event.getEntity(), StopReason.DEATH);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerQuitEvent(PlayerQuitEvent event) {
        this.gSitMain.getPlayerSitService().stopPlayerSit(event.getPlayer(), StopReason.DISCONNECT);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerTeleportEvent(PlayerTeleportEvent event) {
        this.gSitMain.getPlayerSitService().stopPlayerSit(event.getPlayer(), StopReason.TELEPORT);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void entityDamageEvent(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && event.getEntity() instanceof LivingEntity && event.getEntity().getVehicle() != null && event.getEntity().getVehicle().getScoreboardTags().contains("GSit_PlayerSitEntity")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerInteractAtEntityEvent(PlayerInteractAtEntityEvent event) {
        Entity rightClicked = event.getRightClicked();
        if (!(rightClicked instanceof Player)) {
            return;
        }
        Player target = (Player)rightClicked;
        if (!this.gSitMain.getConfigService().PS_ALLOW_SIT && !this.gSitMain.getConfigService().PS_ALLOW_SIT_NPC) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)player, "PlayerSit", "PlayerSit.*")) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            return;
        }
        if (this.gSitMain.getConfigService().PS_EMPTY_HAND_ONLY && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (!player.isValid() || !target.isValid() || player.isSneaking() || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (this.gSitMain.getConfigService().FEATUREFLAGS.contains("DISABLE_PLAYERSIT_ELYTRA") && player.isGliding()) {
            return;
        }
        if (this.gSitMain.getCrawlService().isPlayerCrawling(player)) {
            return;
        }
        double distance = this.gSitMain.getConfigService().PS_MAX_DISTANCE;
        if (distance > 0.0 && target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0).distanceSquared(player.getLocation().clone().add(0.0, player.getHeight() / 2.0, 0.0)) > distance * distance) {
            return;
        }
        if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(target.getLocation(), player, "playersit")) {
            return;
        }
        if (this.gSitMain.getPassengerUtil().isEntityInPassengerList((Entity)target, (Entity)player) || this.gSitMain.getPassengerUtil().isEntityInPassengerList((Entity)player, (Entity)target)) {
            return;
        }
        long amount = this.gSitMain.getPassengerUtil().getEntityPassengerCount((Entity)target) + 1L + this.gSitMain.getPassengerUtil().getEntityVehicleCount((Entity)target) + this.gSitMain.getPassengerUtil().getEntityPassengerCount((Entity)player);
        if (this.gSitMain.getConfigService().PS_MAX_STACK > 0L && this.gSitMain.getConfigService().PS_MAX_STACK <= amount) {
            return;
        }
        Entity highestEntity = this.gSitMain.getPassengerUtil().getTopEntityPassenger((Entity)target);
        if (!(highestEntity instanceof Player)) {
            return;
        }
        Player highestPlayer = (Player)highestEntity;
        boolean isNPC = this.isPlayerNPC(highestPlayer);
        if (isNPC && !this.gSitMain.getConfigService().PS_ALLOW_SIT_NPC || !isNPC && !this.gSitMain.getConfigService().PS_ALLOW_SIT) {
            return;
        }
        if (!this.gSitMain.getToggleService().canPlayerUsePlayerSit(player.getUniqueId()) || !this.gSitMain.getToggleService().canPlayerUsePlayerSit(highestPlayer.getUniqueId())) {
            return;
        }
        this.gSitMain.getPlayerSitService().sitOnPlayer(player, highestPlayer);
    }

    private boolean isPlayerNPC(Player player) {
        return !Bukkit.getOnlinePlayers().contains(player);
    }
}

