/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.cmd;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.StopReason;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GCrawlCommand
implements CommandExecutor {
    private final GSitMain gSitMain;

    public GCrawlCommand(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "Crawl", "Crawl.*")) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getCrawlService().isAvailable()) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-version-error", "%Version%", this.gSitMain.getVersionManager().getServerVersion());
                return true;
            }
            Crawl crawl = this.gSitMain.getCrawlService().getCrawlByPlayer(player);
            if (crawl != null) {
                this.gSitMain.getCrawlService().stopCrawl(crawl, StopReason.GET_UP);
                return true;
            }
            if (!player.isValid() || !player.isOnGround() || player.getVehicle() != null || player.isSleeping()) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-crawl-now-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-crawl-world-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(player.getLocation(), player, "crawl")) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-crawl-region-error", new Object[0]);
                return true;
            }
            if (this.gSitMain.getCrawlService().startCrawl(player) == null) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-crawl-region-error", new Object[0]);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle") && this.gSitMain.getConfigService().C_DOUBLE_SNEAK) {
            if (this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "CrawlToggle", "Crawl.*")) {
                boolean toggle = this.gSitMain.getToggleService().canPlayerUseCrawl(player.getUniqueId());
                if (args.length > 1 && args[1].equalsIgnoreCase("off")) {
                    toggle = true;
                }
                if (args.length > 1 && args[1].equalsIgnoreCase("on")) {
                    toggle = false;
                }
                if (toggle) {
                    this.gSitMain.getToggleService().setPlayerCanUseCrawl(player.getUniqueId(), false);
                    this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gcrawl-toggle-off", new Object[0]);
                } else {
                    this.gSitMain.getToggleService().setPlayerCanUseCrawl(player.getUniqueId(), true);
                    this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gcrawl-toggle-on", new Object[0]);
                }
            } else {
                Bukkit.dispatchCommand((CommandSender)sender, (String)label);
            }
        } else {
            Bukkit.dispatchCommand((CommandSender)sender, (String)label);
        }
        return true;
    }
}

