/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;

public class ToggleService {
    private final GSitMain gSitMain;
    private final HashMap<UUID, Boolean> sitCache = new HashMap();
    private final HashMap<UUID, Boolean> playersitCache = new HashMap();
    private final HashMap<UUID, Boolean> crawlCache = new HashMap();

    public ToggleService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public void createDataTables() {
        try {
            this.gSitMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gsit_sit_toggle (uuid TEXT);", new Object[0]);
            this.gSitMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gsit_player_toggle (uuid TEXT);", new Object[0]);
            this.gSitMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gsit_crawl_toggle (uuid TEXT);", new Object[0]);
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not create toggle database tables!", e);
        }
        this.sitCache.clear();
        this.playersitCache.clear();
        this.crawlCache.clear();
    }

    public void clearEntitySitToggleCache(UUID entityUuid) {
        this.sitCache.remove(entityUuid);
        this.playersitCache.remove(entityUuid);
        this.crawlCache.remove(entityUuid);
    }

    public boolean canEntityUseSit(UUID entityUuid) {
        if (this.sitCache.containsKey(entityUuid)) {
            return this.sitCache.get(entityUuid);
        }
        try {
            ResultSet resultSet = this.gSitMain.getDataService().executeAndGet("SELECT uuid FROM gsit_sit_toggle WHERE uuid = ?", entityUuid.toString());
            boolean canUseSit = this.gSitMain.getConfigService().S_DEFAULT_SIT_MODE == !resultSet.next();
            this.sitCache.put(entityUuid, canUseSit);
            return canUseSit;
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check sit toggle!", e);
            return true;
        }
    }

    public boolean canPlayerUsePlayerSit(UUID playerUuid) {
        if (this.playersitCache.containsKey(playerUuid)) {
            return this.playersitCache.get(playerUuid);
        }
        try {
            ResultSet resultSet = this.gSitMain.getDataService().executeAndGet("SELECT uuid FROM gsit_player_toggle WHERE uuid = ?", playerUuid.toString());
            boolean canUsePlayerSit = this.gSitMain.getConfigService().PS_DEFAULT_SIT_MODE == !resultSet.next();
            this.playersitCache.put(playerUuid, canUsePlayerSit);
            return canUsePlayerSit;
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check player sit toggle!", e);
            return true;
        }
    }

    public boolean canPlayerUseCrawl(UUID playerUuid) {
        if (this.crawlCache.containsKey(playerUuid)) {
            return this.crawlCache.get(playerUuid);
        }
        try {
            ResultSet resultSet = this.gSitMain.getDataService().executeAndGet("SELECT uuid FROM gsit_crawl_toggle WHERE uuid = ?", playerUuid.toString());
            boolean canUseCrawl = this.gSitMain.getConfigService().C_DEFAULT_CRAWL_MODE == !resultSet.next();
            this.crawlCache.put(playerUuid, canUseCrawl);
            return canUseCrawl;
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not check crawl toggle!", e);
            return true;
        }
    }

    public void setEntityCanUseSit(UUID entityUuid, boolean canUseSit) {
        try {
            boolean deleteEntry;
            boolean bl = deleteEntry = canUseSit && this.gSitMain.getConfigService().S_DEFAULT_SIT_MODE || !canUseSit && !this.gSitMain.getConfigService().S_DEFAULT_SIT_MODE;
            if (deleteEntry) {
                this.gSitMain.getDataService().execute("DELETE FROM gsit_sit_toggle WHERE uuid = ?", entityUuid.toString());
            } else {
                this.gSitMain.getDataService().execute("INSERT INTO gsit_sit_toggle (uuid) VALUES (?)", entityUuid.toString());
            }
            this.sitCache.put(entityUuid, canUseSit);
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not set sit toggle!", e);
        }
    }

    public void setPlayerCanUsePlayerSit(UUID playerUuid, boolean canUsePlayerSit) {
        try {
            boolean deleteEntry;
            boolean bl = deleteEntry = canUsePlayerSit && this.gSitMain.getConfigService().PS_DEFAULT_SIT_MODE || !canUsePlayerSit && !this.gSitMain.getConfigService().PS_DEFAULT_SIT_MODE;
            if (deleteEntry) {
                this.gSitMain.getDataService().execute("DELETE FROM gsit_player_toggle WHERE uuid = ?", playerUuid.toString());
            } else {
                this.gSitMain.getDataService().execute("INSERT INTO gsit_player_toggle (uuid) VALUES (?)", playerUuid.toString());
            }
            this.playersitCache.put(playerUuid, canUsePlayerSit);
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not set player sit toggle!", e);
        }
    }

    public void setPlayerCanUseCrawl(UUID playerUuid, boolean canUseCrawl) {
        try {
            boolean deleteEntry;
            boolean bl = deleteEntry = canUseCrawl && this.gSitMain.getConfigService().C_DEFAULT_CRAWL_MODE || !canUseCrawl && !this.gSitMain.getConfigService().C_DEFAULT_CRAWL_MODE;
            if (deleteEntry) {
                this.gSitMain.getDataService().execute("DELETE FROM gsit_crawl_toggle WHERE uuid = ?", playerUuid.toString());
            } else {
                this.gSitMain.getDataService().execute("INSERT INTO gsit_crawl_toggle (uuid) VALUES (?)", playerUuid.toString());
            }
            this.crawlCache.put(playerUuid, canUseCrawl);
        }
        catch (SQLException e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not set crawl toggle!", e);
        }
    }
}

