/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerPoseEvent;
import dev.geco.gsit.api.event.PlayerStopPoseEvent;
import dev.geco.gsit.api.event.PrePlayerPoseEvent;
import dev.geco.gsit.api.event.PrePlayerStopPoseEvent;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public class PoseService {
    public static final String POSE_TAG = "GSit_POSE";
    private final GSitMain gSitMain;
    private final boolean available;
    private final HashMap<UUID, Pose> poses = new HashMap();
    private final HashMap<Block, Set<Pose>> blockPoses = new HashMap();
    private HashMap<PoseType, Integer> poseCount = new HashMap();
    private HashMap<PoseType, Long> poseTime = new HashMap();

    public PoseService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        this.available = gSitMain.getVersionManager().isNewerOrVersion(18, 0);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public HashMap<UUID, Pose> getAllPoses() {
        return this.poses;
    }

    public boolean isPlayerPosing(Player player) {
        return this.poses.containsKey(player.getUniqueId());
    }

    public Pose getPoseByPlayer(Player player) {
        return this.poses.get(player.getUniqueId());
    }

    public void removeAllPoses() {
        for (Pose pose : new ArrayList<Pose>(this.poses.values())) {
            this.removePose(pose, StopReason.PLUGIN);
        }
    }

    public boolean isBlockWithPose(Block block) {
        return this.blockPoses.containsKey(block);
    }

    public Set<Pose> getPosesByBlock(Block block) {
        return this.blockPoses.getOrDefault(block, Collections.emptySet());
    }

    public boolean kickPoseEntitiesFromBlock(Block block, Player player) {
        if (!this.isBlockWithPose(block)) {
            return true;
        }
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)player, "Kick.Pose", "Kick.*")) {
            return false;
        }
        for (Pose pose : this.getPosesByBlock(block)) {
            if (this.removePose(pose, StopReason.KICKED)) continue;
            return false;
        }
        return true;
    }

    public Pose createPose(Block block, Player player, PoseType poseType) {
        return this.createPose(block, player, poseType, 0.0, 0.0, 0.0, player.getLocation().getYaw(), this.gSitMain.getConfigService().CENTER_BLOCK);
    }

    public Pose createPose(Block block, Player player, PoseType poseType, double xOffset, double yOffset, double zOffset, float seatRotation, boolean sitInBlockCenter) {
        Location returnLocation = player.getLocation();
        Location seatLocation = this.gSitMain.getSitService().getSeatLocation(block, returnLocation, xOffset, yOffset, zOffset, sitInBlockCenter);
        if (!this.gSitMain.getEntityUtil().isSitLocationValid(seatLocation)) {
            return null;
        }
        PrePlayerPoseEvent prePlayerPoseEvent = new PrePlayerPoseEvent(player, block);
        Bukkit.getPluginManager().callEvent((Event)prePlayerPoseEvent);
        if (prePlayerPoseEvent.isCancelled()) {
            return null;
        }
        seatLocation.setYaw(seatRotation);
        Entity seatEntity = this.gSitMain.getEntityUtil().createSeatEntity(seatLocation, (Entity)player, true);
        if (seatEntity == null) {
            return null;
        }
        if (this.gSitMain.getConfigService().CUSTOM_MESSAGE) {
            this.gSitMain.getMessageService().sendActionBarMessage(player, "Messages.action-pose-info", new Object[0]);
            if (this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
                this.gSitMain.getTaskService().runDelayed(() -> this.gSitMain.getMessageService().sendActionBarMessage(player, "Messages.action-pose-info", new Object[0]), (Entity)player, 2L);
            }
        }
        Pose pose = this.gSitMain.getEntityUtil().createPose(new Seat(block, seatLocation, (LivingEntity)player, seatEntity, returnLocation), poseType);
        pose.spawn();
        this.poses.put(player.getUniqueId(), pose);
        this.blockPoses.computeIfAbsent(block, b -> new HashSet()).add(pose);
        this.poseCount.merge(poseType, 1, Integer::sum);
        Bukkit.getPluginManager().callEvent((Event)new PlayerPoseEvent(pose));
        return pose;
    }

    public boolean removePose(Pose pose, StopReason stopReason) {
        return this.removePose(pose, stopReason, true);
    }

    public boolean removePose(Pose pose, StopReason stopReason, boolean useSafeDismount) {
        PrePlayerStopPoseEvent prePlayerStopPoseEvent = new PrePlayerStopPoseEvent(pose, stopReason);
        Bukkit.getPluginManager().callEvent((Event)prePlayerStopPoseEvent);
        if (prePlayerStopPoseEvent.isCancelled() && stopReason.isCancellable()) {
            return false;
        }
        Seat seat = pose.getSeat();
        Player player = pose.getPlayer();
        if (useSafeDismount) {
            this.gSitMain.getSitService().handleSafeSeatDismount(seat);
        }
        this.blockPoses.remove(seat.getBlock());
        this.poses.remove(player.getUniqueId());
        pose.remove();
        seat.getSeatEntity().remove();
        Bukkit.getPluginManager().callEvent((Event)new PlayerStopPoseEvent(pose, stopReason));
        this.poseTime.merge(pose.getPoseType(), seat.getLifetimeInNanoSeconds(), Long::sum);
        return true;
    }

    public Map<PoseType, Integer> getPoseCount() {
        return this.poseCount;
    }

    public Map<PoseType, Integer> getPoseTime() {
        return this.poseTime.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Math.toIntExact((Long)e.getValue() / 1000000000L)));
    }

    public void resetPoseStats() {
        this.poseCount.clear();
        this.poseTime.clear();
    }
}

