/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.model;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class Seat {
    protected Block block;
    protected Location location;
    protected final LivingEntity entity;
    protected final Entity seatEntity;
    protected Location returnLocation;
    private final long spawnTime = System.nanoTime();

    public Seat(@NotNull Block block, @NotNull Location location, @NotNull LivingEntity entity, @NotNull Entity seatEntity, @NotNull Location returnLocation) {
        this.block = block;
        this.location = location;
        this.entity = entity;
        this.seatEntity = seatEntity;
        this.returnLocation = returnLocation;
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    @NotNull
    public Seat setBlock(@NotNull Block block) {
        this.block = block;
        return this;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    @NotNull
    public Seat setLocation(@NotNull Location location) {
        this.location = location;
        return this;
    }

    @NotNull
    public LivingEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public Entity getSeatEntity() {
        return this.seatEntity;
    }

    @NotNull
    public Location getReturnLocation() {
        return this.returnLocation.clone();
    }

    @NotNull
    public Seat setReturnLocation(@NotNull Location returnLocation) {
        this.returnLocation = returnLocation;
        return this;
    }

    public long getLifetimeInNanoSeconds() {
        return System.nanoTime() - this.spawnTime;
    }

    @NotNull
    public String toString() {
        return this.seatEntity.getUniqueId().toString();
    }
}

