/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_20.model;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_20.entity.BoxEntity;
import dev.geco.gsit.model.StopReason;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class Crawl
implements dev.geco.gsit.model.Crawl {
    private final GSitMain gSitMain = GSitMain.getInstance();
    private final Player player;
    private final EntityPlayer serverPlayer;
    protected final BoxEntity boxEntity;
    private Location blockLocation;
    private boolean boxEntityExist = false;
    protected final BlockData blockData = Material.BARRIER.createBlockData();
    private final Listener listener;
    private final Listener moveListener;
    private final Listener stopListener;
    private boolean finished = false;
    private final long spawnTime = System.nanoTime();

    public Crawl(final Player player) {
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.boxEntity = new BoxEntity(player.getLocation());
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityToggleSwimEvent(EntityToggleSwimEvent event) {
                if (event.getEntity() == player) {
                    event.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEvent(PlayerInteractEvent event) {
                if (event.isAsynchronous() || event.getPlayer() != player || Crawl.this.blockLocation == null || !Crawl.this.blockLocation.getBlock().equals((Object)event.getClickedBlock()) || event.getHand() != EquipmentSlot.HAND) {
                    return;
                }
                event.setCancelled(true);
                Crawl.this.gSitMain.getTaskService().run(() -> {
                    if (!Crawl.this.finished) {
                        Crawl.this.buildBlock(Crawl.this.blockLocation);
                    }
                }, false, (Entity)player);
            }
        };
        this.moveListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerMoveEvent(PlayerMoveEvent event) {
                if (event.isAsynchronous() || event.getPlayer() != player) {
                    return;
                }
                Location fromLocation = event.getFrom();
                Location toLocation = event.getTo();
                if (fromLocation.getX() != toLocation.getX() || fromLocation.getZ() != toLocation.getZ() || fromLocation.getY() != toLocation.getY()) {
                    Crawl.this.tick(toLocation);
                }
            }
        };
        this.stopListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerToggleSneakEvent(PlayerToggleSneakEvent event) {
                if (!event.isAsynchronous() && event.getPlayer() == player && event.isSneaking()) {
                    Crawl.this.gSitMain.getCrawlService().stopCrawl(Crawl.this, StopReason.GET_UP);
                }
            }
        };
    }

    @Override
    public void start() {
        this.player.setSwimming(true);
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gSitMain);
        this.gSitMain.getTaskService().runDelayed(() -> {
            Bukkit.getPluginManager().registerEvents(this.moveListener, (Plugin)this.gSitMain);
            if (this.gSitMain.getConfigService().C_GET_UP_SNEAK) {
                Bukkit.getPluginManager().registerEvents(this.stopListener, (Plugin)this.gSitMain);
            }
            this.tick(this.player.getLocation());
        }, false, (Entity)this.player, 1L);
    }

    private void tick(Location location) {
        boolean canSetBarrier;
        if (this.finished || !this.checkCrawlValid()) {
            return;
        }
        Location tickLocation = location.clone();
        Block locationBlock = tickLocation.getBlock();
        int blockSize = (int)((tickLocation.getY() - (double)tickLocation.getBlockY()) * 100.0);
        tickLocation.setY((double)tickLocation.getBlockY() + (blockSize >= 40 ? 2.49 : 1.49));
        Block aboveBlock = tickLocation.getBlock();
        boolean hasSolidBlockAbove = aboveBlock.getBoundingBox().contains(tickLocation.toVector()) && !aboveBlock.getCollisionShape().getBoundingBoxes().isEmpty();
        boolean canPlaceBlock = this.isValidArea(locationBlock.getRelative(BlockFace.UP), aboveBlock, this.blockLocation != null ? this.blockLocation.getBlock() : null);
        boolean bl = canSetBarrier = canPlaceBlock && (aboveBlock.getType().isAir() || hasSolidBlockAbove);
        if (this.blockLocation == null || !aboveBlock.equals((Object)this.blockLocation.getBlock())) {
            this.destoryBlock();
            if (canSetBarrier && !hasSolidBlockAbove) {
                this.buildBlock(tickLocation);
                return;
            }
        }
        if (canSetBarrier || hasSolidBlockAbove) {
            this.destoryEntity();
            return;
        }
        Location playerLocation = location.clone();
        this.gSitMain.getTaskService().run(() -> {
            if (this.finished) {
                return;
            }
            int height = locationBlock.getBoundingBox().getHeight() >= 0.4 || playerLocation.getY() % 0.015625 == 0.0 ? ((double)this.player.getFallDistance() > 0.7 ? 0 : blockSize) : 0;
            playerLocation.setY(playerLocation.getY() + (height >= 40 ? 1.5 : 0.5));
            this.boxEntity.b(height >= 40 ? 100 - height : 0);
            if (!this.boxEntityExist) {
                this.boxEntity.e(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                this.serverPlayer.c.a((Packet)new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)this.boxEntity));
                this.boxEntityExist = true;
                this.serverPlayer.c.a((Packet)new PacketPlayOutEntityMetadata(this.boxEntity.af(), this.boxEntity.aj().c()));
            } else {
                this.serverPlayer.c.a((Packet)new PacketPlayOutEntityMetadata(this.boxEntity.af(), this.boxEntity.aj().c()));
                this.boxEntity.setPosRaw(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ(), true);
                this.serverPlayer.c.a((Packet)new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.boxEntity));
            }
        }, true, playerLocation);
    }

    @Override
    public void stop() {
        this.finished = true;
        HandlerList.unregisterAll((Listener)this.listener);
        HandlerList.unregisterAll((Listener)this.moveListener);
        HandlerList.unregisterAll((Listener)this.stopListener);
        this.player.setSwimming(false);
        this.destoryBlock();
        this.destoryEntity();
    }

    private void buildBlock(Location location) {
        this.blockLocation = location;
        if (this.blockLocation != null) {
            this.player.sendBlockChange(this.blockLocation, this.blockData);
        }
    }

    private void destoryBlock() {
        if (this.blockLocation == null) {
            return;
        }
        this.player.sendBlockChange(this.blockLocation, this.blockLocation.getBlock().getBlockData());
        this.blockLocation = null;
    }

    private void destoryEntity() {
        if (!this.boxEntityExist) {
            return;
        }
        this.serverPlayer.c.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.boxEntity.af()}));
        this.boxEntityExist = false;
    }

    private boolean checkCrawlValid() {
        if (this.serverPlayer.aV() || this.player.isFlying()) {
            this.gSitMain.getCrawlService().stopCrawl(this, StopReason.ENVIRONMENT);
            return false;
        }
        return true;
    }

    private boolean isValidArea(Block blockUp, Block aboveBlock, Block locationBlock) {
        return blockUp.equals((Object)aboveBlock) || blockUp.equals((Object)locationBlock);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public long getLifetimeInNanoSeconds() {
        return System.nanoTime() - this.spawnTime;
    }

    public String toString() {
        return this.boxEntity.ct().toString();
    }
}

