/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_19_4.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_19_4.entity.PlayerSitEntity;
import dev.geco.gsit.mcv.v1_19_4.entity.SeatEntity;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import io.papermc.paper.chunk.system.entity.EntityLookup;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityUtil
implements dev.geco.gsit.util.EntityUtil {
    private final GSitMain gSitMain;
    private Field entityManager = null;

    public EntityUtil(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
        if (gSitMain.isPaperServer()) {
            return;
        }
        ArrayList<Field> entityManagerFieldList = new ArrayList<Field>();
        for (Field field : WorldServer.class.getDeclaredFields()) {
            if (!field.getType().equals(PersistentEntitySectionManager.class)) continue;
            entityManagerFieldList.add(field);
        }
        if (entityManagerFieldList.isEmpty()) {
            return;
        }
        this.entityManager = (Field)entityManagerFieldList.get(0);
        this.entityManager.setAccessible(true);
    }

    @Override
    public void setEntityLocation(Entity entity, Location location) {
        ((CraftEntity)entity).getHandle().b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public boolean isSitLocationValid(Location location) {
        return true;
    }

    @Override
    public boolean isPlayerSitLocationValid(Location location) {
        return true;
    }

    @Override
    public Entity createSeatEntity(Location location, Entity entity, boolean canRotate) {
        if (entity == null || !entity.isValid()) {
            return null;
        }
        net.minecraft.world.entity.Entity rider = ((CraftEntity)entity).getHandle();
        SeatEntity seatEntity = new SeatEntity(location);
        boolean riding = true;
        if (!this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
            riding = rider.a((net.minecraft.world.entity.Entity)seatEntity, true);
        }
        if (!this.spawnEntity((net.minecraft.world.entity.Entity)seatEntity)) {
            return null;
        }
        if (this.gSitMain.getConfigService().ENHANCED_COMPATIBILITY) {
            riding = rider.a((net.minecraft.world.entity.Entity)seatEntity, true);
        }
        if (!riding || !seatEntity.r.contains((Object)rider)) {
            seatEntity.ai();
            return null;
        }
        if (canRotate) {
            seatEntity.startRotate();
        }
        return seatEntity.getBukkitEntity();
    }

    @Override
    public Set<UUID> createPlayerSitEntities(Player player, Player target) {
        if (player == null || !player.isValid()) {
            return Collections.emptySet();
        }
        Object topEntity = ((CraftEntity)target).getHandle();
        int maxEntities = this.gSitMain.getPlayerSitService().getSitEntityStackCount();
        if (maxEntities <= 0) {
            ((CraftEntity)player).getHandle().a(topEntity, true);
            return Collections.emptySet();
        }
        HashSet<UUID> playerSitEntityIds = new HashSet<UUID>();
        for (int entityCount = 1; entityCount <= maxEntities; ++entityCount) {
            PlayerSitEntity playerSitEntity = new PlayerSitEntity(target.getLocation());
            playerSitEntity.a((net.minecraft.world.entity.Entity)topEntity, true);
            if (entityCount == maxEntities) {
                ((CraftEntity)player).getHandle().a((net.minecraft.world.entity.Entity)playerSitEntity, true);
            }
            if (!this.spawnEntity((net.minecraft.world.entity.Entity)playerSitEntity)) {
                ((CraftEntity)player).getHandle().a(topEntity, true);
                return playerSitEntityIds;
            }
            playerSitEntityIds.add(playerSitEntity.cs());
            topEntity = playerSitEntity;
        }
        return playerSitEntityIds;
    }

    private boolean spawnEntity(net.minecraft.world.entity.Entity entity) {
        if (!this.gSitMain.isPaperServer()) {
            try {
                PersistentEntitySectionManager entityLookup = (PersistentEntitySectionManager)this.entityManager.get(entity.H.getWorld().getHandle());
                return entityLookup.a((EntityAccess)entity);
            }
            catch (Throwable e) {
                this.gSitMain.getLogger().log(Level.SEVERE, "Could not spawn entity", e);
                return false;
            }
        }
        LevelEntityGetter levelEntityGetter = entity.H.E();
        if (!(levelEntityGetter instanceof EntityLookup)) {
            return false;
        }
        EntityLookup entityLookup = (EntityLookup)levelEntityGetter;
        return entityLookup.addNewEntity(entity);
    }

    @Override
    public Pose createPose(Seat seat, PoseType poseType) {
        return new dev.geco.gsit.mcv.v1_19_4.model.Pose(seat, poseType);
    }

    @Override
    public Crawl createCrawl(Player player) {
        return new dev.geco.gsit.mcv.v1_19_4.model.Crawl(player);
    }
}

