/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.cmd;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class GSitCommand
implements CommandExecutor {
    private final GSitMain gSitMain;

    public GSitCommand(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            Block block;
            if (!this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "Sit", "Sit.*")) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                return true;
            }
            Seat seat = this.gSitMain.getSitService().getSeatByEntity((LivingEntity)player);
            if (seat != null) {
                this.gSitMain.getSitService().removeSeat(seat, StopReason.GET_UP);
                return true;
            }
            if (!player.isValid() || player.isSneaking() || !player.isOnGround() || player.getVehicle() != null || player.isSleeping() || this.gSitMain.getSitService().isEntityBlocked((Entity)player)) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-now-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-world-error", new Object[0]);
                return true;
            }
            Location playerLocation = player.getLocation();
            Block block2 = block = playerLocation.getBlock().isPassable() ? playerLocation.subtract(0.0, 0.0625, 0.0).getBlock() : playerLocation.getBlock();
            if (this.gSitMain.getConfigService().MATERIALBLACKLIST.contains(block.getType())) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-location-error", new Object[0]);
                return true;
            }
            boolean overSize = false;
            try {
                for (BoundingBox boundingBox : block.getCollisionShape().getBoundingBoxes()) {
                    if (!(boundingBox.getMaxY() > 1.25)) continue;
                    overSize = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.gSitMain.getConfigService().ALLOW_UNSAFE && (!block.getRelative(BlockFace.UP).isPassable() || overSize || block.isPassable() && this.gSitMain.getConfigService().CENTER_BLOCK)) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-location-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(block.getLocation(), player, "sit")) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-region-error", new Object[0]);
                return true;
            }
            if (!this.gSitMain.getConfigService().SAME_BLOCK_REST && !this.gSitMain.getSitService().kickSeatEntitiesFromBlock(block, (LivingEntity)player)) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-kick-error", new Object[0]);
                return true;
            }
            if (Tag.STAIRS.isTagged((Keyed)block.getType()) ? this.gSitMain.getSitService().createStairSeatForEntity(block, (LivingEntity)player) == null : this.gSitMain.getSitService().createSeat(block, (LivingEntity)player) == null) {
                this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-sit-error", new Object[0]);
            }
            return true;
        }
        switch (args[0]) {
            case "toggle": {
                if (this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "SitToggle", "Sit.*") && !this.gSitMain.getConfigService().S_SITMATERIALS.isEmpty()) {
                    boolean toggle = this.gSitMain.getToggleService().canEntityUseSit(player.getUniqueId());
                    if (args.length > 1 && args[1].equalsIgnoreCase("off")) {
                        toggle = true;
                    }
                    if (args.length > 1 && args[1].equalsIgnoreCase("on")) {
                        toggle = false;
                    }
                    if (toggle) {
                        this.gSitMain.getToggleService().setEntityCanUseSit(player.getUniqueId(), false);
                        this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gsit-toggle-off", new Object[0]);
                        break;
                    }
                    this.gSitMain.getToggleService().setEntityCanUseSit(player.getUniqueId(), true);
                    this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gsit-toggle-on", new Object[0]);
                    break;
                }
            }
            case "playertoggle": {
                if (this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "PlayerSitToggle", "PlayerSit.*") && this.gSitMain.getConfigService().PS_ALLOW_SIT) {
                    boolean toggle = this.gSitMain.getToggleService().canPlayerUsePlayerSit(player.getUniqueId());
                    if (args.length > 1 && args[1].equalsIgnoreCase("off")) {
                        toggle = true;
                    }
                    if (args.length > 1 && args[1].equalsIgnoreCase("on")) {
                        toggle = false;
                    }
                    if (toggle) {
                        this.gSitMain.getToggleService().setPlayerCanUsePlayerSit(player.getUniqueId(), false);
                        this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gsit-playertoggle-off", new Object[0]);
                        break;
                    }
                    this.gSitMain.getToggleService().setPlayerCanUsePlayerSit(player.getUniqueId(), true);
                    this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-gsit-playertoggle-on", new Object[0]);
                    break;
                }
            }
            default: {
                Bukkit.dispatchCommand((CommandSender)sender, (String)label);
            }
        }
        return true;
    }
}

