/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.cmd;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.StopReason;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class GLayCommand
implements CommandExecutor {
    private final GSitMain gSitMain;

    public GLayCommand(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Block block;
        if (!(sender instanceof Player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)sender, "Lay", "Pose.*")) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
            return true;
        }
        if (!this.gSitMain.getPoseService().isAvailable()) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.command-version-error", "%Version%", this.gSitMain.getVersionManager().getServerVersion());
            return true;
        }
        Pose pose = this.gSitMain.getPoseService().getPoseByPlayer(player);
        if (pose != null && pose.getPoseType() == PoseType.LAY) {
            this.gSitMain.getPoseService().removePose(pose, StopReason.GET_UP);
            return true;
        }
        if (!player.isValid() || player.isSneaking() || !player.isOnGround() || player.getVehicle() != null || player.isSleeping() || this.gSitMain.getSitService().isEntityBlocked((Entity)player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-now-error", new Object[0]);
            return true;
        }
        if (!this.gSitMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-world-error", new Object[0]);
            return true;
        }
        Location playerLocation = player.getLocation();
        Block block2 = block = playerLocation.getBlock().isPassable() ? playerLocation.subtract(0.0, 0.0625, 0.0).getBlock() : playerLocation.getBlock();
        if (this.gSitMain.getConfigService().MATERIALBLACKLIST.contains(block.getType())) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-location-error", new Object[0]);
            return true;
        }
        boolean overSize = false;
        try {
            for (BoundingBox boundingBox : block.getCollisionShape().getBoundingBoxes()) {
                if (!(boundingBox.getMaxY() > 1.25)) continue;
                overSize = true;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.gSitMain.getConfigService().ALLOW_UNSAFE && (!block.getRelative(BlockFace.UP).isPassable() || overSize || block.isPassable() && this.gSitMain.getConfigService().CENTER_BLOCK)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-location-error", new Object[0]);
            return true;
        }
        if (!this.gSitMain.getEnvironmentUtil().canUseInLocation(block.getLocation(), player, "pose")) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-region-error", new Object[0]);
            return true;
        }
        if (!this.gSitMain.getConfigService().SAME_BLOCK_REST && !this.gSitMain.getPoseService().kickPoseEntitiesFromBlock(block, player)) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-kick-error", new Object[0]);
            return true;
        }
        pose = this.gSitMain.getPoseService().createPose(block, player, PoseType.LAY);
        if (pose == null) {
            this.gSitMain.getMessageService().sendMessage(sender, "Messages.action-pose-error", new Object[0]);
        }
        return true;
    }
}

